ViewSettings = {
	Cockpit = {
	[1] = {-- briefing podium
		CockpitLocalPoint      = {-120.0, -6.0,20.0},	--  {-4, 0.1, -5.0}cockpit model line up with external model  {forward/back,up/down,left/right}
		CockpitLocalPointAzimuth  = 0,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,		
	},
	[2] = {-- pilot chair 01
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,		
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[3] = {-- pilot chair 02
		CockpitLocalPoint      = {-120.0, -6.0,20.0},	--cockpit model line up with external model {forward/back,up/down,left/right}
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,		
	},
	[4] = {-- pilot chair 03
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[5] = {-- pilot chair 04
		CockpitLocalPoint      = {-120.0, -6.0,20.0},	--cockpit model line up with external model {forward/back,up/down,left/right}
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,		
	},
	[6] = {-- pilot chair 05
		CockpitLocalPoint      = {-120.0, -6.0,20.0}, 
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[7] = {-- pilot chair 06
		CockpitLocalPoint      = {-120.0, -6.0,20.0},	--cockpit model line up with external model {forward/back,up/down,left/right}
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,		
	},
	[8] = {-- pilot chair 07
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[9] = {-- pilot chair 08
		CockpitLocalPoint      = {-120.0, -6.0,20.0},	--cockpit model line up with external model {forward/back,up/down,left/right}
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,		
	},
	[10] = {-- pilot chair 09
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[11] = {-- pilot chair 10
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,		
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[12] = {-- pilot chair 11
		CockpitLocalPoint      = {-120.0, -6.0,20.0},	--cockpit model line up with external model {forward/back,up/down,left/right}
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,		
	},
	[13] = {-- pilot chair 12
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[14] = {-- pilot chair 13
		CockpitLocalPoint      = {-120.0, -6.0,20.0},	--cockpit model line up with external model {forward/back,up/down,left/right}
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,		
	},
	[15] = {-- pilot chair 14
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[16] = {-- pilot chair 15
		CockpitLocalPoint      = {-120.0, -6.0,20.0},	--cockpit model line up with external model {forward/back,up/down,left/right}
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,		
	},
	[17] = {-- pilot chair 16
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[18] = {-- pilot chair 17
		CockpitLocalPoint      = {-120.0, -6.0,20.0},	--cockpit model line up with external model {forward/back,up/down,left/right}
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,		
	},
	[19] = {-- pilot chair 18
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[20] = {-- pilot chair 19
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[21] = {-- pilot chair 20
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[22] = {-- desk chair
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 180,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[23] = {-- casual chair 01
		CockpitLocalPoint      = {-120.0, -6.0,20.0}, 
		CockpitLocalPointAzimuth  = 140,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[24] = {-- casual chair 02
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = 20,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },
	[25] = {-- casual chair 03
		CockpitLocalPoint      = {-120.0, -6.0,20.0},
		CockpitLocalPointAzimuth  = -10,
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {217.5,-90,90}, -- View right/left, View down/up 
		limits_6DOF            = {x = {-10,10},y = {-3,3},z = {-7,7},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human nexk, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = false,																						
	 },		 
	}, 
	Chase = {	-- F4 view
		LocalPoint      = {0.885,0.915,0.0}, 
		AnglesDefault   = {0.0,-15.0},
	}, 
	Arcade = {
		LocalPoint      = {-20.0,5.0,0.0},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

local function pilot_head_pos(tab)	-- briefing podium
    if not tab then
	   tab = {}
	end
	tab.viewAngle = tab.viewAngle  or 75 -- initial FOV
	tab.hAngle    = tab.hAngle     or  0
	tab.vAngle    = tab.vAngle     or -9 -- angles down pilot view
	tab.x_trans   = tab.x_trans    or  0.97  -- moves pilot view forward from x=0 (cockpit model)
	tab.y_trans   = tab.y_trans    or  1.65  -- moves view up
	tab.z_trans   = tab.z_trans    or  4.90 -- moves view right
	tab.rollAngle = tab.rollAngle  or  0
	return tab
end

local function pilot2_head_pos(tab)	-- chair pilots
    if not tab then
	   tab = {}
	end
	tab.viewAngle = tab.viewAngle  or 75 -- initial FOV
	tab.hAngle    = tab.hAngle     or  0
	tab.vAngle    = tab.vAngle     or  9 -- angles down pilot view
	tab.x_trans   = tab.x_trans    or  0  -- moves pilot view forward from x=0 (cockpit model)
	tab.y_trans   = tab.y_trans    or  0  -- moves view up
	tab.z_trans   = tab.z_trans    or  0  -- moves view right
	tab.rollAngle = tab.rollAngle  or  0
	return tab
end

SnapViews = {
[1] = {-- player slot 1
	[1] = pilot_head_pos({}),	-- num 0
	[2] = pilot_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot_head_pos({}),
	[4] = pilot_head_pos({}),
	[5] = pilot_head_pos({}),
	[6] = pilot_head_pos({}),
	[7] = pilot_head_pos({}),
	[8] = pilot_head_pos({}),
	[9] = pilot_head_pos({}),
	[10] = pilot_head_pos({}),
	[11] = pilot_head_pos(),--look at left mirror
	[12] = pilot_head_pos(),--look at right mirror
	[13] = pilot_head_pos({}),	-- default view
},
[2] = {-- player slot 2
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 3.324, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 6.193, -- right
	}),	-- default view	
},
[3] = {-- player slot 3
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 3.324, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 5.561, -- right
	}),	-- default view	
},
[4] = {-- player slot 4
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 3.324, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 4.930, -- right 
	}),	-- default view	
},
[5] = {-- player slot 5
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 3.324, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 4.303, -- right 
	}),	-- default view	
},
[6] = {-- player slot 6
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 3.324, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 2.546, -- right 
	}),	-- default view	
},
[7] = {-- player slot 7
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 3.324, -- forward
					y_trans	 = 1.161, -- up 
					z_trans	 = 1.915, -- right
	}),	-- default view	
},
[8] = {-- player slot 8
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 3.324, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 1.294, -- right
	}),	-- default view	
},
[9] = {-- player slot 9
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 3.324, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 0.663, -- right
	}),	-- default view	
},
[10] = {-- player slot 10
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 4.863, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 6.193, -- right
	}),	-- default view		
},
[11] = {-- player slot 11
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 4.863, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 5.561, -- right,
	}),	-- default view	
},
[12] = {-- player slot 12
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 4.863, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 =  4.930, -- right
	}),	-- default view	
},
[13] = {-- player slot 13
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 4.863, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 4.303, -- right
	}),	-- default view	
},
[14] = {-- player slot 14
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 4.863, -- forward 
					y_trans	 = 1.161, -- up
					z_trans	 = 2.546, -- right
	}),	-- default view	
},
[15] = {-- player slot 15
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 4.863, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 1.915, -- right
	}),	-- default view	
},
[16] = {-- player slot 16
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 4.863, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 1.294, -- right
	}),	-- default view	
},
[17] = {-- player slot 17
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 4.863, -- forward 
					y_trans	 = 1.161, -- up
					z_trans	 = 0.663, -- right
	}),	-- default view	
},
[18] = {-- player slot 18
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 6.421, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 6.193, -- right
	}),	-- default view	
},
[19] = {-- player slot 19
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 6.421, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 5.561, -- right
	}),	-- default view	
},
[20] = {-- player slot 20
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 6.421, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 4.930, -- right
	}),	-- default view	
},
[21] = {-- player slot 21
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 6.421, -- forward
					y_trans	 = 1.161, -- up
					z_trans	 = 4.312, -- right
	}),	-- default view	
},
[22] = {-- player slot 22
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 8.673, -- forward 
					y_trans	 = 1.361, -- up
					z_trans	 = 4.883, -- right
	}),	-- default view	
},
[23] = {-- player slot 23
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 7.598, -- forward 
					y_trans	 = 1.161, -- up
					z_trans	 = 1.167, -- right
	}),	-- default view	
},
[24] = {-- player slot 24
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 5.879, -- forward 
					y_trans	 = 1.161, -- up
					z_trans	 = 1.487, -- right
	}),	-- default view	
},
[25] = {-- player slot 25
	[1] = pilot2_head_pos({}),	-- num 0
	[2] = pilot2_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot2_head_pos({}),
	[4] = pilot2_head_pos({}),
	[5] = pilot2_head_pos({}),
	[6] = pilot2_head_pos({}),
	[7] = pilot2_head_pos({}),
	[8] = pilot2_head_pos({}),
	[9] = pilot2_head_pos({}),
	[10] = pilot2_head_pos({}),
	[11] = pilot2_head_pos({}),--look at left mirror
	[12] = pilot2_head_pos({}),--look at right mirror
	[13] = pilot2_head_pos({
					x_trans	 = 5.752, -- forward 
					y_trans	 = 1.161, -- up
					z_trans	 = 2.300, -- right
	}),	-- default view	
},
}
