#pragma once
#ifndef DATA_H
#define DATA_H
//=========================================================================//
//
//		FILE NAME	: Data.h
//		AUTHOR		: Joshua Nelson
//		DATE		: October 2020
//
//		This file falls under the licence found in the root ExternalFM directory.
//
//		DESCRIPTION	:	Contains all the data tables and contstants for the flight model.
//
//================================ Includes ===============================//
//=========================================================================//


//Tables
//***********************************//
//			 OLD TABLES				 //
//									 //
//		  DO NOT DELETE THESE		 //
//***********************************//

//#define d_CLalpha {-0.62,-0.5929322197774497,-0.5658644395548995,-0.5387966593323492,-0.511728879109799,-0.48466109888724873,-0.45759331866469843,-0.43052553844214825,-0.40345775821959795,-0.3763899779970477,-0.3493221977744975,-0.3222544175519472,-0.295186637329397,-0.26811885710684674,-0.2410510768842965,-0.21398329666174626,-0.18290710325079987,-0.14639046545254625,-0.10987382765429264,-0.07335718985603912,-0.0368405520577855,-0.0003239142595318767,0.042643546110487186,0.0857488175633278,0.1288540890161682,0.17195936046900862,0.21443151629351237,0.256860889066799,0.2992902618400856,0.3417196346133724,0.3839807976005338,0.42606148090253004,0.4681421642045261,0.5102228475065221,0.5523035308085184,0.5930871583321505,0.6335069949277878,0.6739268315234249,0.714346668119062,0.7547665047146993,0.7953618508583834,0.8360441418068678,0.8705066082263391,0.8994578452099521,0.9212646678844486,0.9336366173395014,0.9348031740232255,0.9235012999676309,0.8970901677354586,0.8771220328342895,0.863298529314007,0.8528257868596284,0.8478470339374391,0.8428682810152499,0.8379124795129725,0.8355784298812838,0.833244380249595,0.8300110854300122,0.8136781166212667,0.7784223543862703,0.7174176301114356,0.6699784618581941,0.6279601605284113,0.585941859198629,0.5706247231504185,0.581309044811902,0.5919933664733855,0.6026776881348691,0.6133620097963527,0.6240463314578362,0.6347306531193196,0.6454149747808032,0.65546308508979,0.659757058331076,0.664051031572362,0.668345004813648,0.672638978054934,0.67693295129622,0.681226924537506,0.685520897778792,0.689814871020078,0.694108844261364,0.69840281750265,0.6884703221691076,0.6778291501329559,0.6671879780968041,0.6565468060606523,0.6459056340245004,0.6352644619883487,0.6246232899521968,0.6139821179160452,0.6033409458798933,0.5926997738437414,0.5820586018075897,0.5714174297714378,0.5607762577352862,0.5501350856991343,0.5394939136629825,0.5288527416268307,0.5182115695906789,0.5075703975545273,0.4969292255183754,0.4862880534822235,0.4756468814460718,0.4650057094099199,0.45436453737376825,0.44372336533761636,0.4330821933014645,0.42244102126531285,0.41179984922916096,0.4011586771930093,0.3905175051568574,0.37987633312070573,0.36923516108455384,0.358593989048402,0.34795281701225034,0.33731164497609845,0.3266704729399468,0.3160293009037949,0.305388128867643,0.2947469568314913,0.2841057847953395,0.2734646127591878,0.26282344072303593,0.25218226868688404,0.24154109665073237,0.23089992461458048,0.2202587525784288,0.20961758054227697,0.19897640850612508,0.1883352364699734,0.17769406443382152,0.16705289239766985,0.15641172036151796,0.14577054832536607,0.1351293762892144,0.1244882042530625,0.11384703221691084,0.10320586018075906,0.09256468814460717,0.0819235161084555,0.0712823440723036,0.060641172036151936,0.05}
//#define d_CD_hstab_alpha {1.85,1.8444099378881988,1.8388198757763976,1.8332298136645964,1.8276397515527951,1.8220496894409939,1.8164596273291926,1.8108695652173914,1.8052795031055902,1.7993788819875776,1.788198757763975,1.7770186335403728,1.76583850931677,1.7546583850931676,1.7434782608695654,1.7322981366459627,1.7211180124223602,1.7099378881987577,1.6981366459627327,1.6813664596273292,1.6645962732919255,1.6478260869565218,1.631055900621118,1.6142857142857143,1.5975155279503106,1.5807453416149069,1.5639751552795031,1.5453416149068324,1.5173913043478262,1.48944099378882,1.4614906832298138,1.4335403726708076,1.4055900621118014,1.377639751552795,1.349689440993789,1.3217391304347827,1.291801242236025,1.2549068322981367,1.2180124223602486,1.1811180124223606,1.1442236024844723,1.1073291925465838,1.0704347826086957,1.0335403726708077,0.9966459627329194,0.9585093167701864,0.9171428571428573,0.8757763975155283,0.834409937888199,0.7930434782608696,0.7516770186335405,0.7103105590062115,0.6689440993788822,0.6275776397515529,0.5877018633540374,0.5508074534161493,0.5139130434782611,0.47701863354037277,0.4401242236024845,0.4090062111801245,0.3788198757763977,0.3486335403726709,0.31844720496894446,0.2895652173913046,0.2627329192546585,0.2359006211180125,0.20906832298136646,0.18223602484472073,0.16155279503105602,0.14142857142857151,0.12130434782608722,0.10118012422360269,0.08316770186335415,0.06779503105590068,0.05242236024844722,0.03704968944099395,0.02692546583850939,0.017608695652173958,0.009316770186335456,0.005590062111801283,0.0018633540372671106,0.001863354037267063,0.0055900621118012365,0.009316770186335362,0.017608695652173836,0.02692546583850927,0.037049689440993565,0.05242236024844703,0.06779503105590048,0.08316770186335395,0.10118012422360242,0.1213043478260867,0.14142857142857124,0.16155279503105577,0.18223602484472007,0.20906832298136613,0.23590062111801216,0.2627329192546582,0.28956521739130425,0.3184472049689437,0.3486335403726705,0.3788198757763973,0.4090062111801237,0.440124223602484,0.47701863354037227,0.5139130434782606,0.5508074534161489,0.5877018633540367,0.6275776397515523,0.6689440993788817,0.7103105590062104,0.7516770186335398,0.7930434782608691,0.8344099378881984,0.8757763975155277,0.9171428571428565,0.9585093167701864,0.9966459627329189,1.0335403726708068,1.0704347826086955,1.1073291925465834,1.1442236024844712,1.1811180124223601,1.218012422360248,1.2549068322981358,1.2918012422360245,1.321739130434782,1.3496894409937887,1.3776397515527947,1.4055900621118007,1.4335403726708074,1.4614906832298133,1.48944099378882,1.517391304347826,1.5453416149068318,1.5639751552795031,1.5807453416149067,1.5975155279503102,1.614285714285714,1.6310559006211178,1.6478260869565213,1.6645962732919253,1.6813664596273288,1.6981366459627327,1.7099378881987575,1.72111801242236,1.7322981366459627,1.743478260869565,1.7546583850931676,1.76583850931677,1.7770186335403724,1.788198757763975,1.7993788819875776,1.80527950310559,1.8108695652173914,1.8164596273291924,1.8220496894409937,1.8276397515527951,1.8332298136645961,1.8388198757763976,1.8444099378881988,1.85}
//#define d_CLalpha {0.0,-0.014498480243161211,-0.028996960486322044,-0.043495440729483255,-0.05799392097264446,-0.0724924012158053,-0.08699088145896651,-0.10148936170212772,-0.11297264437689981,-0.1230942249240121,-0.13321580547112466,-0.1433373860182372,-0.15345896656534946,-0.163580547112462,-0.17370212765957455,-0.18382370820668686,-0.1939452887537994,-0.20406686930091195,-0.2141884498480242,-0.22431003039513675,-0.2344316109422493,-0.24455319148936183,-0.254483282674772,-0.2617325227963526,-0.268981762917933,-0.27623100303951365,-0.2834802431610942,-0.29072948328267484,-0.29797872340425524,-0.30522796352583587,-0.31247720364741627,-0.3197264437689969,-0.3269756838905775,-0.3342249240121581,-0.3414741641337387,-0.3487234042553191,-0.3559726443768997,-0.3627963525835865,-0.3690881458966565,-0.37537993920972645,-0.3816717325227964,-0.3879635258358662,-0.3942553191489362,-0.40054711246200597,-0.4068389057750759,-0.41313069908814587,-0.4194224924012158,-0.4257142857142856,-0.4320060790273556,-0.43829787234042555,-0.44458966565349545,-0.4508814589665653,-0.45717325227963523,-0.4634650455927051,-0.469756838905775,-0.4755927051671732,-0.47914893617021276,-0.48270516717325224,-0.48626139817629177,-0.4898176291793313,-0.4933738601823708,-0.4969300911854103,-0.5004863221884498,-0.5040425531914894,-0.5075987841945289,-0.5111550151975683,-0.5141641337386018,-0.5149848024316109,-0.51580547112462,-0.5166261398176292,-0.5174468085106383,-0.5182674772036474,-0.5190881458966565,-0.5199088145896656,-0.5184283669934968,-0.5166602798611807,-0.5148921927288644,-0.5131241055965483,-0.5113560184642322,-0.509587931331916,-0.5078198441995999,-0.5060517570672837,-0.5042836699349675,-0.500992197918118,-0.4974096092988078,-0.4938270206794977,-0.49024443206018753,-0.4866618434408773,-0.4830792548215672,-0.47949666620225706,-0.4759140775829469,-0.47233148896363675,-0.4687489003443266,-0.46516631172501643,-0.4615837231057063,-0.4580011344863961,-0.45462762819884306,-0.4523332856162369,-0.45003894303363073,-0.44774460045102465,-0.44545025786841846,-0.44315591528581233,-0.4408615727032062,-0.43856723012060006,-0.4362728875379939,-0.4339785449553878,-0.43168420237278166,-0.4293898597901755,-0.43399061424897284,-0.44000283910618254,-0.4460150639633922,-0.4520272888206019,-0.4699273893954743,-0.4994540936942149,-0.524556984601472,-0.5322436886131277,-0.5399303926247834,-0.5412480618202377,-0.542507528813806,-0.5437669958073743,-0.5450488959622691,-0.5473760438227799,-0.5497031916832907,-0.5520303395438015,-0.5543574874043122,-0.5591544519310476,-0.5648933938402023,-0.5731424864704572,-0.5828473638452879,-0.5951805290201186,-0.6040383407534461,-0.6085786931352394,-0.6074115359173387,-0.6022870875095248,-0.5945825433607193,-0.5819429815321958,-0.567974796392621,-0.5517596081663161,-0.5331338203824609,-0.5135064674853816,-0.4939263163835434,-0.47447987874194786,-0.4550334411003523,-0.4355870034587573,-0.41614056581716174,-0.3966941281755662,-0.37724769053397117,-0.35746637340793663,-0.33711530431947506,-0.316764235231014,-0.2964131661425524,-0.2760620970540908,-0.2557110279656298,-0.23536096931340328,-0.21504202856310126,-0.19472308781279923,-0.17440414706249774,-0.1540852063121957,-0.13376626556189367,-0.11344685806254082,-0.09311075742064531,-0.07277465677874981,-0.05243855613685484,-0.03210245549495934,-0.011766354853063835,0.013534834091086821,0.04565314366876699,0.07777145324644717,0.10988976282412735,0.14200807240180668,0.17412638197948685,0.20562150976391722,0.2370992130574171,0.2685769163509178,0.3000546196444185,0.33153232293791834,0.36301002623141904,0.3942541359472449,0.42549066059465024,0.4567271852420564,0.4879637098894626,0.5192002345368679,0.550436759184274,0.5808285391790893,0.6107238089863175,0.6406190787935464,0.6705143486007754,0.7004096184080043,0.7303048882152325,0.7602001580224614,0.7903641373732967,0.8206229730896264,0.8492275531414422,0.8738506167443505,0.8954818281220216,0.9153439967097012,0.9262019225133344,0.9343407646512094,0.9366903763447642,0.9293123037243503,0.9152324142422926,0.8957710457679323,0.8812137297056862,0.8688400907603036,0.8602316778965717,0.8529719798468995,0.8492485432700824,0.8455251066932652,0.8418016701164479,0.8380782335396306,0.8362737941303241,0.8345105403393284,0.8327472865483327,0.8308894471099503,0.818681152503203,0.8064728578964557,0.7679886138852716,0.7228301249577853,0.6954265981855414,0.6861770214821419,0.6769274447787426,0.667677868075343,0.6605997842925777,0.6641295421119717,0.6676592999313657,0.6711890577507599,0.6747188155701539,0.6782485733895479,0.681778331208942,0.685308089028336,0.6888378468477301,0.6923676046671241,0.6958973624865182,0.6994271203059123,0.7045935731934632,0.7100771272026114,0.7155606812117596,0.7210442352209079,0.7265277892300561,0.7320113432392044,0.7374948972483524,0.7429784512575006,0.7484620052666489,0.7539455592757971,0.7594291132849453,0.7649126672940936,0.7703962213032418,0.7754432342733867,0.7782058704176307,0.7809685065618748,0.7837311427061188,0.7864937788503628,0.7892564149946067,0.7920190511388506,0.7947816872830946,0.7975443234273386,0.7998480243161095,0.7984802431610942,0.7971124620060791,0.7957446808510639,0.7943768996960487,0.7930091185410335,0.7916413373860183,0.790273556231003,0.7856231003039514,0.7801519756838906,0.77468085106383,0.7692097264437692,0.7637386018237083,0.7582674772036475,0.7527963525835867,0.7473252279635259,0.741854103343465,0.7363829787234044,0.7309118541033436,0.7219300911854105,0.7122462006079028,0.7025623100303952,0.6928784194528875,0.6831945288753803,0.6735106382978726,0.663826747720365,0.6541428571428572,0.6444589665653496,0.634775075987842,0.6250911854103348,0.6154072948328271,0.6057234042553195,0.5960395136778118,0.5863556231003041,0.5766717325227964,0.5669878419452887,0.5573039513677815,0.5468069908814593,0.5356595744680854,0.5245121580547114,0.5133647416413375,0.5022173252279636,0.4910699088145902,0.4799224924012162,0.4687750759878423,0.4576276595744683,0.44648024316109436,0.4353328267477204,0.42418541033434704,0.41303799392097307,0.40189057750759916,0.3907431610942252,0.37551063829787257,0.35998632218844995,0.3444620060790273,0.3289376899696055,0.31341337386018286,0.29788905775076024,0.2823647416413376,0.26684042553191506,0.2513161094224924,0.23579179331307062,0.220267477203648,0.20474316109422538,0.18921884498480276,0.17369452887538014,0.15606382978723415,0.13376899696048625,0.1114741641337395,0.0891793313069916,0.0668844984802437,0.0445896656534958,0.022294832826747907,0.0}
//#define d_CDalpha {1.55,1.5195341820590185,1.489068364118037,1.4586025461770549,1.4281367282360733,1.3976709102950917,1.3672050923541101,1.3367392744131283,1.3062734564721465,1.275807638531165,1.2453418205901832,1.2148760026492016,1.18441018470822,1.1539443667672382,1.1234785488262564,1.0930127308852748,1.0625469129442933,1.0320810950033117,1.0016152770623297,0.9711494591213482,0.9406836411803665,0.9102178232393848,0.8797520052984031,0.8492861873574216,0.8188203694164398,0.7883545514754582,0.7578887335344764,0.7274229155934948,0.6969570976525132,0.6664912797115314,0.6360254617705499,0.6055596438295681,0.5750938258885865,0.5446280079476049,0.5141621900066231,0.48369637206564153,0.45323055412465973,0.42276473618367816,0.3914953271028038,0.3578504672897196,0.32420560747663557,0.29056074766355156,0.253644859813084,0.21158878504672893,0.1696028037383178,0.13385514018691597,0.09810747663551417,0.07567757009345791,0.06095794392523363,0.04892523364485982,0.04471962616822431,0.0405140186915888,0.03630841121495326,0.03210280373831775,0.0291588785046729,0.029831775700934565,0.035771028037383155,0.04207943925233647,0.048387850467289724,0.06095794392523363,0.07567757009345791,0.09810747663551386,0.13385514018691597,0.16960280373831776,0.21158878504672893,0.253644859813084,0.2905607476635512,0.32420560747663557,0.35785046728971964,0.3914953271028037,0.4227647361836779,0.4532305541246595,0.4836963720656414,0.514162190006623,0.5446280079476047,0.5750938258885863,0.6055596438295678,0.6360254617705497,0.6664912797115314,0.696957097652513,0.7274229155934946,0.7578887335344763,0.788354551475458,0.8188203694164395,0.8492861873574217,0.8797520052984033,0.9102178232393849,0.9406836411803665,0.9711494591213481,1.0016152770623297,1.0320810950033112,1.062546912944293,1.0930127308852746,1.1234785488262564,1.1539443667672384,1.18441018470822,1.2148760026492016,1.2453418205901832,1.2758076385311647,1.3062734564721465,1.3367392744131281,1.36720509235411,1.3976709102950915,1.428136728236073,1.458602546177055,1.4890683641180367,1.5195341820590182,1.55}
//#define d_CL_hstab_alpha {0.0, -0.04111675126903527, -0.08223350253807118, -0.12335025380710646, -0.16446700507614237, -0.19776649746192893, -0.22631979695431453, -0.2548730964467006, -0.2834263959390862, -0.31197969543147225, -0.34053299492385786, -0.36908629441624347, -0.3976395939086295, -0.4261928934010151, -0.44781725888324886, -0.4683756345177665, -0.4889340101522841, -0.5094923857868021, -0.5300507614213197, -0.5506091370558374, -0.5711675126903553, -0.5917258883248729, -0.6117702090493401, -0.627702090493401, -0.643633971937462, -0.6595658533815228, -0.6754977348255836, -0.6914296162696447, -0.7073614977137055, -0.7232933791577665, -0.7392252606018275, -0.7551571420458882, -0.7710890234899492, -0.7870209049340101, -0.802952786378071, -0.818884667822132, -0.8321871076464468, -0.8420118988769035, -0.8518366901073604, -0.8616614813378173, -0.8714862725682742, -0.881311063798731, -0.8916254571208121, -0.9019611374903553, -0.9106768189509307, -0.9137225042301185, -0.9167681895093063, -0.9198138747884941, -0.9228595600676819, -0.9259052453468698, -0.9289509306260576, -0.9291015228426396, -0.9277309644670051, -0.9263604060913706, -0.924989847715736, -0.9236192893401015, -0.9209819787854484, -0.9127018630697123, -0.9044217473539763, -0.8961416316382403, -0.8878615159225043, -0.8792246602190356, -0.869563615518528, -0.8599025708180204, -0.8502415261175127, -0.8534702353484079, -0.8703807106598984, -0.9465228426395934, -0.9826395939086293, -0.9991539763106599, -0.9822335025238579, -0.9653130287370559, -0.9483925549502538, -0.9168781725456854, -0.8809221657791881, -0.8449661590126903, -0.8090101522461931, -0.7730541454796953, -0.7370981387131981, -0.7011421319467008, -0.665186125180203, -0.6292301184137058, -0.593274111647208, -0.5573181048807108, -0.5213620981142135, -0.48540609134771573, -0.4494500845812185, -0.4134940778147207, -0.37753807104822346, -0.3415820642817262, -0.3056260575152284, -0.2696700507487312, -0.2337140439822334, -0.19775803721573615, -0.1618020304492389, -0.12584602368274111, -0.08989001691624388, -0.05393401014974608, -0.01797800338324884, 0.01797800338324834, 0.05393401014974614, 0.08989001691624338, 0.12584602368274117, 0.1618020304492384, 0.19775803721573565, 0.23371404398223344, 0.2696700507487307, 0.3056260575152285, 0.3415820642817257, 0.37753807104822296, 0.41349407781472075, 0.449450084581218, 0.4854060913477158, 0.5213620981142131, 0.5573181048807103, 0.5932741116472081, 0.6292301184137054, 0.6651861251802031, 0.7011421319467004, 0.7370981387131976, 0.7730541454796954, 0.8090101522461927, 0.8449661590126905, 0.8809221657791877, 0.9168781725456849, 0.9483925549502538, 0.9653130287370557, 0.9822335025238579, 0.9991539763106598, 0.9826395939086296, 0.9465228426395941, 0.8703807106598991, 0.8534702353484079, 0.8502415261175126, 0.8599025708180201, 0.8695636155185279, 0.8792246602190354, 0.8878615159225043, 0.8961416316382402, 0.9044217473539762, 0.9127018630697123, 0.9209819787854484, 0.9236192893401015, 0.924989847715736, 0.9263604060913706, 0.9277309644670051, 0.9291015228426396, 0.9289509306260576, 0.9259052453468698, 0.922859560067682, 0.9198138747884941, 0.9167681895093063, 0.9137225042301185, 0.9106768189509307, 0.9019611374903553, 0.8916254571208124, 0.881311063798731, 0.8714862725682742, 0.8616614813378175, 0.8518366901073605, 0.8420118988769036, 0.8321871076464467, 0.8188846678221323, 0.8029527863780712, 0.7870209049340101, 0.7710890234899496, 0.7551571420458885, 0.7392252606018275, 0.7232933791577669, 0.7073614977137058, 0.6914296162696447, 0.6754977348255837, 0.6595658533815231, 0.643633971937462, 0.627702090493401, 0.6117702090493404, 0.5917258883248733, 0.5711675126903553, 0.550609137055838, 0.53005076142132, 0.5094923857868021, 0.4889340101522841, 0.4683756345177668, 0.44781725888324886, 0.4261928934010151, 0.39763959390862996, 0.3690862944162439, 0.34053299492385786, 0.3119796954314727, 0.28342639593908664, 0.2548730964467006, 0.22631979695431453, 0.19776649746192937, 0.16446700507614237, 0.12335025380710646, 0.08223350253807182, 0.04111675126903591, 0.0}
//#define d_CL_vstab_aoa {0.0,-0.026155187445405282,-0.052310374890810946,-0.07846556233621622,-0.1046207497816215,-0.13077593722702716,-0.15693112467243245,-0.1830863121178377,-0.2092414995632434,-0.23539668700864866,-0.2615518744540539,-0.2839290903814416,-0.3048532403403604,-0.3257773902992792,-0.3467015402581983,-0.36762569021711716,-0.38854984017603594,-0.4094739901349551,-0.4303981400938739,-0.45132229005279273,-0.47224644001171157,-0.4931705899706307,-0.5140947399295495,-0.5350188898884686,-0.5559430398473875,-0.5768671898063062,-0.5960864090255854,-0.6114307856547748,-0.6267751622839639,-0.6421195389131531,-0.6574639155423424,-0.6728082921715315,-0.6881526688007208,-0.70349704542991,-0.7188414220590991,-0.7341857986882884,-0.7495301753174776,-0.7648745519466666,-0.780218928575856,-0.7955633052050451,-0.8109076818342342,-0.8262520584634235,-0.8372566114097298,-0.8477186863956757,-0.8581807613816217,-0.8686428363675677,-0.8791049113535135,-0.8860796280108109,-0.8918918918918919,-0.897704155772973,-0.903516419654054,-0.9093286835351351,-0.9151409474162162,-0.9209532112972973,-0.9267654751783784,-0.9325777390594594,-0.935483871,-0.935483871,-0.935483871,-0.935483871,-0.935483871,-0.9253124092081081,-0.9136878814459458,-0.9020633536837838,-0.8904388259216216,-0.876489392607027,-0.855565242635135,-0.8346410926632432,-0.8243969775993244,-0.8191659401452702,-0.8302818948263514,-0.8512060447885135,-0.8942583136432438,-0.9540415992216219,-0.9870967742,-0.9932190254909908,-0.9792695922153152,-0.9488520778513514,-0.8899738447751345,-0.8285963382389187,-0.7672188317027027,-0.7058413251664859,-0.64446381863027,-0.583086312094054,-0.5217088055578372,-0.4603312990216213,-0.3989537924854053,-0.33757628594918854,-0.27619877941297255,-0.21482127287675667,-0.1534437663405398,-0.09206625980432392,-0.03068875326810805,0.03068875326810886,0.09206625980432478,0.15344376634054072,0.21482127287675754,0.27619877941297344,0.33757628594918937,0.3989537924854053,0.4603312990216221,0.521708805557838,0.5830863120940539,0.6444638186302708,0.7058413251664867,0.7672188317027027,0.8285963382389194,0.8899738447751354,0.9488520778513514,0.9792695922153154,0.9932190254909911,0.9870967742,0.954041599221621,0.8942583136432429,0.8512060447885135,0.8302818948263511,0.8191659401452703,0.8243969775993244,0.8346410926632435,0.8555652426351353,0.8764893926070271,0.8904388259216217,0.9020633536837839,0.9136878814459459,0.9253124092081082,0.935483871,0.935483871,0.935483871,0.935483871,0.935483871,0.9325777390594594,0.9267654751783783,0.9209532112972971,0.9151409474162161,0.9093286835351351,0.903516419654054,0.897704155772973,0.8918918918918919,0.8860796280108107,0.8791049113535134,0.8686428363675675,0.8581807613816216,0.8477186863956757,0.8372566114097298,0.8262520584634232,0.810907681834234,0.7955633052050449,0.7802189285758558,0.7648745519466666,0.7495301753174776,0.734185798688288,0.7188414220590988,0.7034970454299098,0.6881526688007207,0.6728082921715315,0.6574639155423424,0.6421195389131529,0.6267751622839637,0.6114307856547746,0.5960864090255854,0.5768671898063062,0.5559430398473875,0.535018889888468,0.5140947399295491,0.49317058997063035,0.47224644001171157,0.45132229005279273,0.4303981400938739,0.40947399013495445,0.38854984017603567,0.3676256902171169,0.346701540258198,0.3257773902992792,0.3048532403403604,0.283929090381441,0.2615518744540536,0.2353966870086483,0.209241499563243,0.18308631211783774,0.15693112467243248,0.1307759372270264,0.10462074978162114,0.07846556233621585,0.052310374890810585,0.026155187445405292,0.0}

//***********************************//
//			CURRENT TABLES			 //
//***********************************//
#define d_CLalpha {0.0,0.02948152154683251,0.05896304309366502,0.0884445646404988,0.1179260861873313,0.1473591001755177,0.1767254930507362,0.20609188592595473,0.23545827880117448,0.264824671676393,0.29408287292583224,0.32320792842279006,0.3523329839197479,0.3814580394167069,0.41058309491366474,0.4394790116069109,0.4674545557897347,0.4954300999725585,0.5234056441553836,0.5513811883382074,0.5793567325210311,0.6053775817691568,0.6293780711923718,0.6533785606155877,0.6673718074823802,0.6726574536831952,0.6779430998840101,0.6780123226940887,0.6747583786785424,0.6691392824770641,0.655868223321101,0.6425971641651378,0.6293261050091745,0.6160550458532108,0.6027839866972476,0.5895129275412845,0.5762418683853212,0.5677347791963301,0.5616096749908256,0.5554845707853211,0.5493594665798165,0.543234362374312,0.5371092581688075,0.5309841539633027,0.5256719245720747,0.5279078184562712,0.5301437123404678,0.5323796062246644,0.5346155001088609,0.5368513939930575,0.539087287877254,0.5418565306883335,0.5469722560364897,0.5520879813846461,0.5572037067328023,0.5623194320809585,0.5674351574291149,0.5725508827772711,0.5776666081254273,0.5827823334735834,0.5878980588217396,0.5930137841698958,0.598129509518052,0.6010711207064876,0.6036484642318702,0.6062258077572529,0.6088031512826355,0.6113804948080181,0.6139578383334008,0.6165351818587834,0.6177210173761468,0.6164449541100918,0.6151688908440368,0.6138928275779817,0.6126167643119267,0.6113407010458716,0.6088949129510702,0.6037906593363914,0.5986864057217125,0.5935821521070337,0.5884778984923548,0.5833736448776758,0.5782693912629969,0.573165137648318,0.5680608840336392,0.5620884923541285,0.5530776174477063,0.5440667425412843,0.5350558676348623,0.5260449927284404,0.5170341178220185,0.5080232429155963,0.49901236800917415,0.4900014931027522,0.48099061819633027,0.4719797432899083,0.46296886838348617,0.4539579934770642,0.4449471185706421,0.4359362436642202,0.4268590085758229,0.4170518114856988,0.4072446143955748,0.3974374173054505,0.3876302202153265,0.3778230231252022,0.3680158260350782,0.35820862894495414,0.3484014318548299,0.33859423476470585,0.3287870376745816,0.31897984058445755,0.3091726434943333,0.2988530617996136,0.2866657555784645,0.27447844935731514,0.262291143136166,0.2501038369150167,0.2379165306938676,0.22572922447271848,0.21354191825156912,0.20135461203042004,0.18916730580927066,0.17697999958812158,0.16479269336697247,0.1526053871458231,0.14041808092467403,0.12823077470352467,0.11462161599082558,0.10072808677981653,0.08683455756880717,0.07294102835779812,0.05904749914678878,0.04515396993577972,0.03126044072477066,0.01736691151376131,0.0034733823027522648,-0.01051821888440388,-0.02454251073027532,-0.03856680257614676,-0.052591094422018494,-0.06661538626788993,-0.08063967811376167,-0.09466396995963311,-0.10827470893401124,-0.12000855410699693,-0.13174239927998235,-0.14347624445296803,-0.15521008962595345,-0.16694393479893913,-0.17867777997192455,-0.19041162514490997,-0.20214547031789565,-0.21387931549088107,-0.22561316066386675,-0.23734700583685217,-0.2490808510098376,-0.2600345511953993,-0.2705004406326168,-0.2809663300698345,-0.291432219507052,-0.3018981089442695,-0.3123639983814872,-0.3228298878187047,-0.3332957772559224,-0.3437616666931399,-0.3542275561303574,-0.36333053974311935,-0.3709102756697248,-0.3784900115963304,-0.3860697475229358,-0.39364948344954126,-0.40122921937614686,-0.4088089553027523,-0.4163886912293579,-0.42396842715596333,-0.43154816308256894,-0.43912789900917437,-0.4467076349357798,-0.4542873708623854,-0.46186710678899084,-0.46944684271559645,-0.4759311926605505,-0.4802247706422018,-0.48451834862385323,-0.4888119266055046,-0.493105504587156,-0.4973990825688073,-0.5016926605504587,-0.5059862385321101,-0.5102798165137614,-0.5137683486238532,-0.514841743119266,-0.5159151376146789,-0.5169885321100918,-0.5180619266055047,-0.5191353211009174,-0.5195784443089879,-0.5174104436123544,-0.5152424429157209,-0.5130744422190873,-0.5109064415224537,-0.5087384408258202,-0.5065704401291866,-0.5044024394325531,-0.5007417881135094,-0.4964385602466441,-0.4921353323797788,-0.4878321045129135,-0.48352887664604816,-0.47922564877918267,-0.47492242091231734,-0.470619193045452,-0.46631596517858676,-0.46201273731172143,-0.4577095094448559,-0.4539741044241651,-0.45120406526953155,-0.4484340261148981,-0.44566398696026455,-0.44289394780563096,-0.44012390865099743,-0.43735386949636396,-0.4345838303417305,-0.43181379118709684,-0.42904375203246337,-0.43614501047260945,-0.4434046855847598,-0.4506643606969102,-0.46930540213641514,-0.5048222626130286,-0.5274748765500066,-0.5369839072489647,-0.5410900056221972,-0.54244888582001,-0.5438077660178227,-0.5457449426412918,-0.5486435652000431,-0.5515421877587944,-0.5544408103175458,-0.560589665001226,-0.5678609948326467,-0.5793742116430777,-0.5936649449811534,-0.60462597140827,-0.6101093783662891,-0.6051442317709564,-0.5969214063508649,-0.5830567153276875,-0.5660670066283938,-0.5464765141471148,-0.5227913441324266,-0.4991074361958962,-0.4755750668811598,-0.45204269756642235,-0.42851032825168595,-0.40497795893694954,-0.3814455896222131,-0.3576224954329728,-0.33312318369849847,-0.3086238719640252,-0.2841245602295519,-0.2596252484950786,-0.23511544137369797,-0.2104131229394193,-0.18571080450514169,-0.16100848607086407,-0.13630616763658646,-0.11161630190919783,-0.08707228086133634,-0.06252825981347587,-0.037984238765615436,-0.013440217717754985,0.017214756779205618,0.0558237190146534,0.09443268125009951,0.13304164348554565,0.17165060572099175,0.20970179663166746,0.2477053631597419,0.2857089296878147,0.3237124962158875,0.3617160627439603,0.399423458466888,0.437114707465015,0.4748059564631405,0.512497205461266,0.5501884544593914,0.5868393686401335,0.6230430137262521,0.6592466588123693,0.6954503038984865,0.7316539489846037,0.7678575940707224,0.8042943751347678,0.8407330978544918,0.8708723174210143,0.8970103309328664,0.9183406248735128,0.9309911259708488,0.9386298131802525,0.9301938025810476,0.9133306847467273,0.8913449408219228,0.8736322998004832,0.8624456382962863,0.8529858616423778,0.848526442321222,0.844067023000066,0.8396076036789101,0.8366273318189947,0.8345367466886852,0.8324461615583755,0.8261290872248964,0.8114998098984245,0.7766496349023727,0.722008311011572,0.6933297856875541,0.6821610547457838,0.6709923238040141,0.6600673108191746,0.6643289095186108,0.6685905082180469,0.6728521069174832,0.6771137056169193,0.6813753043163555,0.6856369030157916,0.6898985017152277,0.694160100414664,0.6984216991141002,0.7041684760690093,0.7107888266334175,0.7174091771978257,0.7240295277622342,0.7306498783266423,0.7372702288910505,0.7438905794554587,0.7505109300198669,0.7571312805842754,0.7637516311486835,0.7703719817130917,0.7760037529731587,0.7793391386602871,0.7826745243474158,0.7860099100345443,0.7893452957216728,0.7926806814088013,0.7960160670959299,0.7993514527830585,0.7986697247706422,0.7970183486238532,0.7953669724770642,0.7937155963302752,0.7920642201834862,0.7904128440366972,0.785045871559633,0.7784403669724771,0.7718348623853208,0.7652293577981649,0.758623853211009,0.7520183486238531,0.7454128440366972,0.738807339449541,0.7322018348623851,0.7222259118532107,0.7105647796330273,0.6989036474128439,0.6872425151926601,0.6755813829724767,0.6639202507522933,0.6522591185321099,0.6405979863119265,0.6289368540917426,0.6172757218715592,0.6056145896513758,0.5939534574311924,0.582292325211009,0.5706311929908252,0.5589700607706418,0.5447039954177837,0.528107200419901,0.5115104054220182,0.49491361042413484,0.47831681542625215,0.4617200204283694,0.4451232254304867,0.428526430432604,0.4119296354347206,0.3953328404368386,0.37727013922992997,0.358541117018921,0.33981209480791197,0.32108307259690294,0.3023540503858939,0.28362502817488494,0.2648960059638759,0.2461669837528669,0.2274379615418579,0.20870893933084889,0.18997991711983828,0.17125089490882925,0.1520115541851534,0.13239716009674657,0.11278276600833972,0.0931683719199329,0.07355397783152606,0.05393958374311923,0.0343251896547124,0.014710795566305557,-0.00347338230275316,-0.017366911513762212,-0.031260440724771264,-0.045153969935780316,-0.05904749914678937,-0.07294102835779842,-0.08683455756880748,-0.10072808677981653,-0.11462161599082558,-0.12823077470352467,-0.1404180809246748,-0.15260538714582392,-0.164792693366973,-0.1769799995881221,-0.1891673058092712,-0.2013546120304203,-0.21354191825156937,-0.22572922447271848,-0.2379165306938676,-0.2501038369150167,-0.26229114313616686,-0.2744784493573159,-0.286665755578465,-0.29885306179961413,-0.30917264349433377,-0.3189798405844578,-0.32878703767458184,-0.33859423476470585,-0.3484014318548299,-0.3582086289449539,-0.3680158260350788,-0.3778230231252029,-0.3876302202153269,-0.39743741730545096,-0.40724461439557497,-0.41705181148569903,-0.42685900857582304,-0.4359362436642202,-0.4449471185706421,-0.45395799347706484,-0.4629688683834868,-0.4719797432899087,-0.48099061819633065,-0.4900014931027526,-0.49901236800917453,-0.5080232429155965,-0.5170341178220185,-0.5260449927284404,-0.5350558676348623,-0.5440667425412851,-0.553077617447707,-0.5620884923541289,-0.5680608840336394,-0.5731651376483182,-0.5782693912629971,-0.583373644877676,-0.5884778984923548,-0.5935821521070337,-0.5986864057217125,-0.6037906593363919,-0.6088949129510707,-0.6113407010458717,-0.6126167643119267,-0.6138928275779817,-0.6151688908440368,-0.6164449541100918,-0.6177210173761468,-0.6165351818587834,-0.6139578383334008,-0.6113804948080179,-0.6088031512826354,-0.6062258077572528,-0.6036484642318701,-0.6010711207064875,-0.598129509518052,-0.5930137841698958,-0.5878980588217396,-0.5827823334735834,-0.5776666081254273,-0.5725508827772706,-0.5674351574291144,-0.5623194320809582,-0.5572037067328021,-0.5520879813846459,-0.5469722560364897,-0.5418565306883335,-0.539087287877254,-0.5368513939930575,-0.5346155001088609,-0.5323796062246642,-0.5301437123404676,-0.5279078184562711,-0.5256719245720746,-0.5309841539633029,-0.5371092581688074,-0.543234362374312,-0.5493594665798165,-0.5554845707853211,-0.5616096749908256,-0.5677347791963306,-0.5762418683853219,-0.589512927541285,-0.6027839866972482,-0.6160550458532114,-0.6293261050091745,-0.6425971641651378,-0.655868223321101,-0.6691392824770641,-0.6747583786785426,-0.6780123226940891,-0.6779430998840099,-0.672657453683195,-0.66737180748238,-0.6533785606155866,-0.6293780711923718,-0.6053775817691568,-0.5793567325210311,-0.5513811883382074,-0.5234056441553812,-0.4954300999725573,-0.4674545557897335,-0.4394790116069097,-0.4105830949136635,-0.3814580394167057,-0.3523329839197479,-0.32320792842279006,-0.29408287292583224,-0.264824671676393,-0.23545827880117198,-0.20609188592595346,-0.17672549305073496,-0.14735910017551646,-0.11792608618733005,-0.08844456464049755,-0.05896304309366503,-0.02948152154683252,0.0}
#define d_CDalpha {0.03,0.0385164514444335,0.04955033206305601,0.0639586390215489,0.08338881780048676,0.10532564969852004,0.13147207668281408,0.16176403668452521,0.19455187375023916,0.23237563275724585,0.27347742786999996,0.31711705738720364,0.3665046270182923,0.418364311130358,0.47359009066563945,0.5336943792394025,0.5962552355212662,0.6629888844396655,0.7328097991982799,0.8040711074829643,0.8761366187016993,0.9466645052169278,1.0159572505768806,1.0789005637678688,1.137569414713384,1.1902338831936188,1.2313194039011073,1.266186225076771,1.2900112010281133,1.3066460007492546,1.3194696314765781,1.3278572939698665,1.3357231118626836,1.3431540592551074,1.3502540758121773,1.357228469661616,1.364028347101562,1.3706284281720191,1.37712839674574,1.3834573462036908,1.389182154027824,1.3943936267780779,1.397715313984976,1.3992546227372853,1.3992532314695265,1.3960504862278424,1.391898820933141,1.3864568380975189,1.3802935580389288,1.3739144273967132,1.3673644940921292,1.3606507079888361,1.3538273875584474,1.3467356677353035,1.3394578849013452,1.332013286954243,1.3236422934246812,1.3133104946444867,1.2998754815805091,1.2780564370844734,1.2507295717700533,1.2119994925437518,1.1640567638882797,1.1105036183993293,1.0475405551070114,0.9810492664999597,0.9112773473371029,0.838416815225457,0.7654806876669312,0.692717217902494,0.6230075923532238,0.5557340094445921,0.49414720393123845,0.43969390325364166,0.39023121387283255,0.34861271676300587,0.30699421965317925,0.26421965317919077,0.21219653179190817,0.16164739884393112,0.1174277456647403,0.08014450867052038,0.06193641618497122,0.04731213872832374,0.03950867052023124,0.0319248554913295,0.028959537572254335,0.028959537572254362,0.031924855491329396,0.03950867052023114,0.047312138728323634,0.06193641618497097,0.08014450867052013,0.1174277456647397,0.16164739884393053,0.21219653179190745,0.26421965317919077,0.3069942196531787,0.3486127167630053,0.390231213872832,0.4396939032536397,0.49414720393123607,0.5557340094445896,0.623007592353222,0.6927172179024929,0.7654806876669299,0.8384168152254542,0.9112773473371,0.9810492664999568,1.0475405551070094,1.1105036183993287,1.1640567638882786,1.2119994925437507,1.2507295717700524,1.278056437084473,1.2998754815805085,1.3133104946444862,1.323642293424681,1.3320132869542427,1.3394578849013445,1.3467356677353028,1.3538273875584472,1.360650707988836,1.3673644940921292,1.373914427396713,1.3802935580389286,1.3864568380975189,1.391898820933141,1.3960504862278424,1.3992532314695265,1.3992546227372855,1.3977153139849763,1.394393626778078,1.3891821540278244,1.3834573462036912,1.3771283967457408,1.3706284281720196,1.3640283471015622,1.3572284696616164,1.350254075812178,1.3431540592551081,1.335723111862684,1.3278572939698667,1.3194696314765781,1.306646000749255,1.2900112010281137,1.2661862250767717,1.231319403901109,1.1902338831936219,1.1375694147133855,1.07890056376787,1.015957250576881,0.9466645052169305,0.8761366187017028,0.8040711074829666,0.7328097991982809,0.6629888844396677,0.5962552355212696,0.5336943792394055,0.47359009066564167,0.418364311130359,0.3665046270182934,0.3171170573872053,0.2734774278700009,0.23237563275724687,0.19455187375024138,0.16176403668452688,0.13147207668281502,0.10532564969852055,0.08338881780048701,0.06395863902154932,0.04955033206305637,0.038516451444433664,0.03}
#define d_CDmach {0.0,0.0,0.0,0.0,0.0,0.000940909090909,0.0197590909091,0.0216283084005,0.0199712313003,0.0183141542002,0.0166570771001,0.015 }
#define d_CDbeta {1.23,0.978284308116,0.731177185308,0.501113771365,0.300529206075,0.141858629225,0.0375371806043,0.0,0.0375371806043,0.141858629225,0.300529206075,0.501113771365,0.731177185308,0.978284308116,1.23 }
#define d_CLflap {0.0,0.010619970851709465,0.021239941703418887,0.03185991255512836,0.044161996549066614,0.05651283744567813,0.06886367834228971,0.08121451923890129,0.09356536013551292,0.10591620103212454,0.11826704192873612,0.1306178828253477,0.1429687237219593,0.1553195646185709,0.1676704055151825,0.18002124641179412,0.19237208730840574,0.20472292820501728,0.21707376910162884,0.22942460999824044,0.24177545089485203,0.2541262917914637,0.26401677179574484,0.2733029526334888,0.28258913347123277,0.28510550964879355,0.28565248810702837,0.2861994665652631,0.28682154083075606,0.28746911933267627,0.2881166978345964,0.28983850718477105,0.29198158353426124,0.29412465988375136,0.29575958414278924,0.2971663584836649,0.2985731328245406,0.2997216840395095,0.3007383766369942,0.3017550692344788,0.30198510194883293,0.3017606200640449,0.30153613817925695,0.3012778239502455,0.30099747935755367,0.3007171347648619,0.29988477205706465,0.2986484936552876,0.2974122152535107,0.29628787224219455,0.29525537365382076,0.294222875065447,0.2940360516068376,0.29462633502422797,0.2952166184416184,0.29602534454664015,0.29705875455894004,0.29809216457124005,0.29891359315101623,0.29949092189940185,0.30006825064778736,0.30069244537415446,0.3013771123301752,0.3020617792861958,0.3026906962707837,0.30323887191743437,0.3037870475640849,0.3053147621502583,0.30843876241565393,0.31156276268104943,0.314856253652866,0.31846160752449715,0.3220669613961281,0.3252532306540079,0.327564888544059,0.32987654643411013,0.33242073875671685,0.33551858449017014,0.33861643022362364,0.34016568703232547,0.3374767004680228,0.3347877139037202,0.33038148086867225,0.32052046492655145,0.3106594489844306,0.3012115905959168,0.293306187074203,0.2854007835524891,0.2756807385287999,0.25786460065014377,0.24004846277148775,0.21977397995177272,0.18609034290809823,0.15240670586442379,0.1216648881031212,0.11118893650927136,0.10071298491542147,0.09126987362345684,0.09126987366301376,0.09126987370257067,0.09126987374212764,0.0912698737816845,0.09126987382124135,0.09126987386079821,0.09126987390035514,0.09126987393991204,0.09126987397899529,0.09126987398492276,0.09126987399085014,0.0912698739967776,0.09126987392577375,0.09126987385367082,0.09126987378156792,0.0912698737094651,0.09126987363736229,0.09126987356525945,0.09126987349315663,0.09126987342105375,0.09126987334895083,0.09126987327684806,0.09126987320474535,0.09126987313264256,0.09102786658719303,0.090750730069806,0.09047359355241903,0.08954068459310105,0.0884875506860957,0.08743441677909038,0.08638128287208496,0.08532814896507963,0.08427501505807429,0.08322188115106893,0.08216874724406366,0.0811156133370583,0.08006247943005301,0.07900934552304767,0.0779562116160424,0.07690307770903705,0.07584994380203164,0.07479680989502628,0.07374367598802094,0.07269054208101561,0.07163740817401032,0.07058427426700496,0.0695311403599996,0.0684780064529942,0.0674248725459888,0.06637173863898349,0.06531860473197812,0.0642654708249728,0.06321233691796746,0.06215920301096218,0.061106069103956856,0.060052935196951485,0.05899980128994611,0.05794666738294077,0.056893533475935426,0.055840399568930055,0.05478726566192474,0.05373413175491937,0.05268099784791402,0.05162786394090871,0.05057473003390342,0.049521596126898104,0.04846846221989277,0.04741532831288737,0.04636219440588196,0.045309060498876626,0.04425592659187134,0.04320279268486607,0.04214965877786076,0.04109652487085538,0.04004339096385004,0.03899025705684464,0.0379371231498393,0.03688398924283395,0.03583085533582862,0.03477772142882322,0.03372458752181787,0.03267145361481252,0.03161831970780718,0.030565185800801833,0.029512051893796507,0.028458917986791163,0.027405784079785847,0.026352650172780517,0.025299516265775188,0.02424638235876989,0.02319324845176457,0.022140114544759202,0.021086980637753834,0.02003384673074847,0.018980712823743126,0.017927578916737782,0.016874445009732425,0.01582131110272708,0.01476817719572174,0.013715043288716408,0.012661909381711078,0.011608775474705763,0.010555641567700426,0.009502507660695056,0.008449373753689662,0.007396239846684319,0.006343105939678975,0.0052899720326736255,0.004236838125668282,0.0031837042186629305,0.00213057031165758,0.0010774364046522364,2.4302497646951776e-05,2.710505431213761e-20,-0.0010531339070052846,-0.0021062678140106677,-0.0031594017210160494,-0.004212535628021433}
#define d_CLslat {0.0,-5.421010862427522,-0.005241367037379541,-0.010482734074759357,-0.01572410111213912,-0.020965468149518773,-0.02620683518689848,-0.03144820222427819,-0.031368383653244646,-0.016043570257264658,-0.0007187568612846964,0.0027643509061028027,-0.0025606159718781774,-0.00670293623242718,-0.007778190966405585,-0.008611569124549412,-0.010116588440471752,-0.01160205420358229,-0.012015691432656794,-0.014312977300064533,-0.01685970351913813,-0.011948849948414273,0.020861166735100634,0.08542871229808735,0.18621064665469,0.2672633244766701,0.311997547099532,0.33915587727936025,0.3507523520959579,0.33506397660354736,0.2573279094768707,0.29209445837375914,0.3103356359373798,0.3103356359373798,0.31033563593737984,0.31033563593737984,0.3103356359612922,0.3103356360406885,0.31033563612008463,0.3103356361994809,0.31033563627887706,0.3076826810059532,0.29760130387366746,0.2875199267413816,0.27743854960909586,0.2673571724768099,0.2572757953445242,0.2471944182122385,0.2371130410799527,0.227031663947667,0.21695028681538106,0.20686890968309535,0.19678753255080958,0.18670615541852392,0.17662477828623802,0.16654340115395225,0.15646202402166642,0.14638064688938063,0.1362992697570949,0.1262178926248092,0.1161365154925234,0.10605513836023762,0.09597376122795169,0.08589238409566607,0.07581100696338028,0.06572962983109443,0.05564825269880869,0.045566875566522946,0.035485498434237095,0.025404121301951358,0.015322744169665616,0.005241367037379763}
#define d_CDflap {0.05,0.049560898259073005,0.04912179651814601,0.04868269477721903,0.04824359303737637,0.04780449129922046,0.04736538956106454,0.04692628782290863,0.04648718608565778,0.04604808434865831,0.045608982611658834,0.045169880874458244,0.04473077913630233,0.04429167739814644,0.043852575659990525,0.04341347392026835,0.04297437217934135,0.04253527043841435,0.042096168697487384,0.04165706695921099,0.04121796522105507,0.04077886348289916,0.04033976174514548,0.03990066000814602,0.03946155827114654,0.03902245653414707,0.03858335479424464,0.038144253053317645,0.03770515131239067,0.03726604957182512,0.03682694783366921,0.03638784609551329,0.035948744357357384,0.03550964261775571,0.03507054087682871,0.03463143913590171,0.034192337394974716,0.03375323566016384,0.03331413392593548,0.032875032191707086,0.032435930455439986,0.031996828714512995,0.031557726973586,0.03111862523265902,0.03067952349365973,0.03024042175550382,0.029801320017347907,0.02936221827895103,0.028923116538024055,0.028484014797097057,0.02804491305617006,0.027605811318446742,0.027166709584218348,0.026727607849989957,0.026288506115761584,0.025849404375708318,0.02541030263478132,0.024971200893854323,0.024532099152927346,0.02409299741200035,0.02365389567107335,0.023214793930146353,0.022775692191026587,0.022336590452870675,0.021897488714714784,0.021458386976438388,0.021019285235511397,0.020580183494584407,0.020141081753657437,0.019701980015642877,0.019262878281414483,0.018823776547186092,0.018384674812957698,0.017945573073195675,0.017506471332268698,0.0170673695913417,0.016628267851017113,0.0161891661128612,0.015750064374705306,0.015310962636549396,0.014871860896706736,0.01443275915577974,0.013993657414852742,0.013554555673925746,0.013115453936926291,0.012676352199926815,0.01223725046292734,0.011798148725475346,0.011359046987319444,0.01091994524916354,0.010480843511007629,0.01004174177155051,0.009602640031731948,0.009163538291913395,0.008724436552094842,0.00828533481227628,0.007846233072457716,0.007407131332639153,0.0069680295950405036,0.0065289278591494715,0.00608982612325843,0.0056507243873673875,0.005211622647984647,0.004772520908443202,0.004333419168901748,0.0038943174292639187,0.0034552156894453586,0.0030161139496268086,0.0025770122098082485,0.0021379104700920957,0.0016988087304120971,0.0012597069907320881,0.0008461488126692636,0.0006028810300364106,0.00035961324740355755,0.00011634546477071,-0.00022909655356699558,-0.0006681982933855486,-0.0011073000332041116,-0.0015464017730226747,-0.001985503512588216,-0.0024246052521296703,-0.0028637069916711147,-0.0033028087312969067,-0.0037419104711154698,-0.004181012210934023,-0.004620113950752586,-0.005059215690571139,-0.005498317430389702,-0.005937419170208265,-0.006376520909661198,-0.006815622645275131,-0.007254724380889054,-0.007693826116502988,-0.00813292785412783,-0.008572029593946384,-0.009011131333764947,-0.0094502330735835,-0.009889334813402062,-0.010328436553220625,-0.010767538293039178,-0.011206640033146899,-0.011645741774073884,-0.012084843515000882,-0.012523945255927878,-0.012963046992486208,-0.0134021487267146,-0.013841250460942981,-0.014280352195462616,-0.014719453936389612,-0.0151585556773166,-0.015597657418243597,-0.016036759157965763,-0.016475860896121675,-0.01691496263427759,-0.017354064372433493,-0.017793166112878563,-0.018232267853805547,-0.018671369594732545,-0.01911047133420332,-0.019549573068431705,-0.019988674802660096,-0.020427776536888476,-0.02086687827519428,-0.021305980016121273,-0.02174508175704826,-0.022184183497975258,-0.02262328523613116,-0.023062386974287075,-0.023501488712442987,-0.023940590451683227,-0.024379692192610224,-0.02481879393353721,-0.02525789567446421,-0.025696997412317492,-0.026136099149316958,-0.02657520088631643,-0.027014302623517016,-0.02745340436167293,-0.02789250609982884,-0.028331607837984742,-0.02877070957770692,-0.029209811318633903,-0.029648913059560897,-0.03008801480048789,-0.030527116538764276,-0.03096621827692019,-0.031405320015076094,-0.03184442175282977,-0.03228352348982924,-0.03272262522682871,-0.033161726963828186,-0.03360082870168242,-0.03403993043983832,-0.03447903217799424,-0.0349125716013082,-0.03530902892298854,-0.035705486244668884,-0.036101943566349215,-0.03645128480220127,-0.036757436292606624,-0.037063587783011984,-0.03736973927341734,-0.03767589076382269,-0.03798204225422805,-0.0382881937446334,-0.0385301694778229,-0.038625457776087425,-0.038720746074351955,-0.03881603437261648,-0.038539714502550206,-0.03810081605114171,-0.03766191759973321,-0.03722301914832472,-0.036784120696916243,-0.03634522224550775,-0.035906323794099256,-0.03539271892123689,-0.03479761613576369,-0.034202513350290516,-0.033607410564817315,-0.03259436977102313,-0.03151863828307275,-0.03044290679512237,-0.029367175303939102,-0.028291443803595814,-0.027215712303252527,-0.02613998080290924,-0.025000181946217778,-0.02382621383217318,-0.022652245718128523,-0.021461969548674683,-0.019912916189621318,-0.01836386283056795,-0.016814809471514654,-0.015265756118485381,-0.013716702773287428,-0.012167649428089474,-0.010618596082891521,-0.009069542726018946,-0.0075204893666884695,-0.005971436007357992,-0.0044223826479913705,-0.002873329288494628,-0.0013242759289979564,0.00022477743049878571,0.0017738307899617947,0.003322884149403118,0.00487193750884444,0.006420990868285692,0.007970044215146292,0.00951909756200689,0.01106815090886749,0.012617204260499172,0.014166257619552473,0.015715310978605845,0.017264364337659217,0.018813417696712586,0.020362471055765958,0.021911524414819257,0.02344970573725515,0.024936244885685965,0.026422784034116784,0.027909323182547595,0.029056654803698827,0.029943057558733787,0.030829460313768747,0.0317158630688037,0.032602265821946426,0.03348866857500309,0.0343750713280598,0.03526443918184088,0.036159366599478646,0.03705429401711642,0.03794922143475415,0.038949162839263335,0.039986168003609705,0.041023173167956076,0.042060178332061986,0.04309718349456477,0.0441341886570676,0.04517119381957043,0.04621514579075447,0.047265465669888096,0.048315785549021675,0.0493661054281553,0.051048584790513774,0.05279126981681629,0.0545339548431188,0.05627663986876762,0.05801932489292254,0.05976200991707746,0.06150469494123238,0.06324737996688128,0.06499006499318372,0.06673275001948623,0.0684428358813826,0.06981063051061852,0.07117842513985445,0.07254621976909031,0.0739105664098937,0.07527115160876587,0.07663173680763803,0.07799232200651018,0.0793529072019144,0.08071349239679851,0.08207407759168261,0.08341835473346142,0.0847164257244821,0.08601449671550274,0.08731256770652343,0.08860819249031464,0.08990251263024977,0.09119683277018492,0.09249115290994918,0.09378547304595554,0.09507979318196191,0.09637411331796827,0.0976162476810827,0.09879054053917188,0.09996483339726112,0.10113912625535035,0.10230309068539159,0.10346488070953101,0.10462667073367038,0.10578846075780982,0.10695025078194924,0.10811204080608866,0.10927383083022808,0.11009713811545528,0.11070284936834175,0.11130856062122822,0.11191427187411468,0.11251998312700115,0.11312569437988759,0.11373140563277406,0.11433711688566052,0.11494282813854699,0.11554853939143346,0.11615425064431989,0.11675996189720636,0.11736567315009283,0.1179713844029793,0.11857709565586576,0.1191828069087522,0.11978851816163867,0.12039422941452513,0.1209999406674116,0.12160565192029807,0.12221136317318451,0.12281707442607097,0.12342278567895744,0.12402849693184391,0.12463420818473038,0.1252399194376168,0.12584563069050328,0.12645134194338975,0.12705705319627622,0.1276627644491627,0.12826847570204913,0.12887418695493558,0.12948192436207945,0.1301031694658006,0.13072441456952177,0.1313456596732429,0.13179498822410185,0.13208672659821172,0.13237846497232159,0.13267020334643145,0.1329619417205413,0.1332536800946512,0.13354541846876106,0.13355388443238644,0.13291487063127455,0.13227585683016266,0.13163684302905077,0.13099782922793887,0.13035881542682695,0.12971980162571506,0.1290807878246032,0.12844177402349127,0.12780276022237938,0.1271637464212675,0.12652473262015557,0.12588571881904367,0.1252467050179318,0.12460769121681989,0.123968677415708,0.12332966361459609,0.12269064981348418,0.12205163601237232,0.12141262221126041,0.1207736084101485,0.12013459460903661,0.1194955808079247,0.11885656700681282,0.11821755320570093,0.11757853940458902,0.11693952560347712,0.11630051180236523,0.11566149800125335,0.11502248420014144,0.11438347039902955,0.11374445659791764,0.11310544279680573,0.11246642899569385,0.11182741519458196,0.11118840139347005,0.11054938759235815,0.10991037379124624,0.10927135999013438,0.10863234618902247,0.10799333238791056,0.10735431858679867,0.10671530478568676,0.10607629098457486,0.10543727718346296,0.10479826338235111,0.1041592495812392,0.10352023578012731,0.1028812219790154,0.1022422081779035,0.1016031943767916,0.1009641805756797,0.10032516677456779,0.0996861529734559,0.09904713917234398,0.09840812537123214,0.09776911157012025,0.09713009776900833,0.09649108396789643,0.09585207016678454,0.09521305636567262,0.09457404256456073,0.09393502876344882,0.09329601496233692,0.09265700116122502,0.09201798736011317,0.09137897355900126,0.09073995975788937,0.09010094595677746,0.08946193215566556,0.08882291835455366,0.08818390455344176,0.08754489075232985,0.08690587695121796,0.08626686315010605,0.0856278493489942,0.08498883554788231,0.0843498217467704,0.0837108079456585,0.0830717941445466,0.08243278034343468,0.08179376654232279,0.0811547527412109,0.08051573894009897,0.07987672513898708,0.07923771133787524,0.07859869753676332,0.07795968373565143,0.07732066993453952,0.07668165613342762,0.07604264233231572,0.07540362853120382,0.07476461473009191,0.07412560092898002,0.07348658712786811,0.07284757332675626,0.07220855952564437,0.07156954572453246,0.07093053192342055,0.07029151812230866,0.06965250432119675,0.06901349052008485,0.06837447671897294,0.06773546291786105,0.06709644911674914,0.06645743531563729,0.0658184215145254,0.06517940771341349,0.06454039391230158,0.06390138011118969,0.06326236631007778,0.06262335250896588,0.06198433870785397,0.06134532490674208,0.06070631110563017,0.06006729730451833,0.059428283503406426,0.05878926970229452,0.05815025590118261,0.05751124210007072,0.05687222829895881,0.056233214497846906,0.05559420069673501,0.05495518689562311,0.0543161730945112,0.05367715929339936,0.053038145492287456,0.05239913169117555,0.05176011789006364,0.05112110408895175,0.05048209028783984,0.049843076486727936,0.04920406268561604,0.048565048884504136,0.04792603508339223,0.04728702128228039,0.046648007481168485,0.04600899368005658,0.045369979878944686,0.04473096607783278,0.04409195227672087,0.043452938475608965,0.04281392467449707,0.042174910873385166,0.04153589707227326,0.040896883271161366,0.040257869470049515,0.03961885566893761,0.038979841867825715,0.03834082806671381,0.0377018142656019,0.037062800464489995,0.0364237866633781,0.035784772862266195,0.03514575906115429,0.034506745260042396,0.033867731458930544,0.03322871765781864,0.032589703856706745,0.03195069005559484,0.03131167625448293,0.03067266245337104,0.03003364865225913,0.029394634851147225,0.028755621050035318,0.028116607248923425,0.027477593447811574,0.026838579646699667,0.026199565845587774,0.025560552044475868,0.02492153824336396,0.024282524442252068,0.02364351064114016,0.023004496840028255,0.022365483038916348,0.021726469237804455,0.021087455436692604,0.02044844163558071,0.019809427834468804,0.019170414033356897,0.01853140023224499,0.017892386431133098,0.01725337263002119,0.016614358828909284,0.015975345027797377,0.015336331226685485,0.014697317425573633,0.01405830362446174,0.013419289823349834,0.012780276022237927,0.01214126222112602,0.011502248420014127,0.01086323461890222,0.010224220817790314,0.009585207016678421,0.008946193215566514,0.008307179414454663,0.00766816561334277,0.007029151812230849,0.0063901380111189565,0.005751124210007064,0.005112110408895143,0.00447309660778325,0.0038340828066713573,0.0031950690055594366,0.0025560552044475437,0.0019170414033357064,0.0012780276022238135,0.0006390138011119206,0.0}
#define d_CDslat {0.0,0.0021393552221065093,0.004278710444213463,0.006418065666319972,0.008557420888426705,0.010696776110533435,0.012836131332639944,0.014975486554746675,0.017114841776853407,0.019254196998959916,0.021393552221066647,0.02353290744317338,0.02567226266527989,0.02781161788738662,0.029950973109493243,0.03209032833159997,0.0342296835537067,0.03636903877581333,0.03850839399791983,0.03999999999999998,0.03999999999999998,0.04990566037735845,0.072688679245283,0.08457547169811315,0.07183962264150942,0.048207547169811356,0.028490566037735827,0.013207547169811278,0.0050000000000000044,0.004386792452830192,0.00014150943396225345,0.0,-0.020566037735849002,-0.016792452830188626,0.004603773584905797,0.017305006685485153,0.023723072351805236,0.030141138018125152,0.036559203684445235,0.04297726935076521,0.04939533501708518,0.05581340068340525,0.062231466349725234,0.06864953201604532,0.07506759768236518,0.08148566334868527,0.08790372901500523,0.09432179468132565,0.10073986034764518,0.10715792601396534,0.11357599168028555,0.11999405734660552,0.12641212301292554,0.13283018867924526}
#define d_Cmalpha {-0.2,-0.20048226504628539,-0.20153808733589929,-0.2031378540362504,-0.20525195231474724,-0.2078507693387986,-0.21090469227581313,-0.21438410829319948,-0.21825940455836632,-0.22250096823872226,-0.22707918650167605,-0.23196444651463635,-0.23712713544501174,-0.24253764046021095,-0.24816634872764257,-0.2539836474147154,-0.25995992368883797,-0.266065564717419,-0.2722709576678672,-0.27854648970759105,-0.28486254800399946,-0.29118951972450097,-0.2974977920365043,-0.30375775210741796,-0.3099397871046507,-0.31601428419561134,-0.32195163054770826,-0.32772221332835033,-0.33329641970494617,-0.33864463684490453,-0.34373725191563387,-0.3485446520845429,-0.3530372245190404,-0.35718535638653487,-0.36095986855291745,-0.3643531038325003,-0.36738840567327496,-0.3700915264590863,-0.37248821857377945,-0.37460423440119944,-0.3764653263251913,-0.3780972467296001,-0.37952574799827077,-0.3807765825150485,-0.38187550266377823,-0.3828482608283049,-0.38372060939247377,-0.38451830074012994,-0.3852670872551181,-0.3859914468744015,-0.38670224238026596,-0.3874020908574843,-0.38809349424077927,-0.3887789544648744,-0.3894609734644922,-0.3901420531743561,-0.39082469552918897,-0.39151140246371396,-0.39220467591265396,-0.392907017810732,-0.3936209300926713,-0.39434891469319466,-0.3950934735470255,-0.39585710858888645,-0.3966423217535007,-0.3974516149755914,-0.39828749018988147,-0.39915244933109384,-0.40004856282099577,-0.4009666404188541,-0.4018854349273562,-0.4027831081443081,-0.4036378218675159,-0.40442773789478587,-0.4051310180239241,-0.4057258240527366,-0.4061903177790296,-0.4065026610006095,-0.4066410155152821,-0.4065928488427356,-0.40653863268542323,-0.40684083697327655,-0.40786903378793693,-0.4099927952110459,-0.4135816933242451,-0.4190080063713348,-0.42665683934115195,-0.4369170936868023,-0.45018164896262364,-0.4674748491562405,-0.49113788486504373,-0.5234455258339651,-0.5646245253775192,-0.6154080758315231,-0.6945322925155857,-0.8844003905174899,-1.0377392284442262,-1.1044499120176654,-1.1509202454276195,-1.1847230400838205,-1.2103931718367986,-1.232465516537084}
#define d_Cmadot {-1.0,-0.9997627180982737,-0.9999518680209171,-1.0005774637160694,-1.0016495191318684,-1.0031780482164525,-1.0051730649179604,-1.00764458318453,-1.0106026169642999,-1.0140571802054088,-1.0180182868559944,-1.022495950864195,-1.0275001861781499,-1.0330410067459965,-1.039128426515874,-1.0457724594359203,-1.0529831194542736,-1.0607704205190724,-1.0691443765784556,-1.0781150015805605,-1.0876923094735265,-1.0978863142054909,-1.1087070297245933,-1.120164469978971,-1.1322686489167633,-1.1450295804861075,-1.1584572786351426,-1.172561757312007,-1.187353030464839,-1.2028411120417766,-1.2190360159909588,-1.2359477562605239,-1.2535878072724909,-1.2722772639117623,-1.2930280252091972,-1.3169454605240727,-1.3451349392156653,-1.3787018306432512,-1.418751504166108,-1.4663893291435122,-1.5227206749347402,-1.5888509108990683,-1.6658854063957735,-1.754538426673477,-1.8496721606583828,-1.9416438573354333,-2.0206948829901146,-2.0767607830728934,-2.084987315847411,-2.035118672559533,-1.959857264118053,-1.8627055657121432,-1.7429807525900456,-1.6}
#define d_Cmq {-3.5094277292596345,-3.5161567596970422,-3.5231526365828003,-3.530683596512638,-3.539017876082285,-3.5484237118874686,-3.5591693405239178,-3.571522998587362,-3.585752922673529,-3.6021273493781476,-3.6209145152969455,-3.642382657025654,-3.6668000111599985,-3.69442933986108,-3.72540943096835,-3.7597561650252067,-3.7974801615505402,-3.8385954276499694,-3.8832158394602985,-3.931569116201113,-3.9838891745237586,-4.0404129917232225,-4.101398343566679,-4.167111659804254,-4.237871697448557,-4.314912123940566,-4.400245407307992,-4.496195029307437,-4.606819861954952,-4.7368814605769884,-4.89221154553636,-5.077795536462455,-5.29021819476004}
#define d_Cmde {-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-0.9645254242636803,-0.8898268900214835,-0.8151283557792866,-0.7404298215370897,-0.6984934374136501,-0.6952094501243437,-0.6919254628350373,-0.6886414755457309,-0.6853574882564244,-0.6820735009671179,-0.6787895136778115,-0.6755055263885051,-0.6722215390991987,-0.6689375518098922,-0.6656535645205858,-0.6623695772312793,-0.659085589941973,-0.6558016026526665,-0.6525176153633601,-0.6482113231275243,-0.6405466476416197,-0.6328819721557152,-0.6252172966698105,-0.617552621183906,-0.6098879456980014,-0.6022232702120969,-0.5981354665753261,-0.5955091149412111,-0.5928827633070959,-0.5902564116729808,-0.5876300600388656,-0.5850037084047506,-0.5823773567706354,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.58,-0.5754011640681334,-0.5669889064041441,-0.5585766487401549,-0.5501643910761658,-0.5346012547615192,-0.5188955918159681,-0.5031899288704171,-0.4861051056397596,-0.46866877100881327,-0.451232436377867,-0.4344109945004253,-0.4188138348035792,-0.4032166751067331,-0.38843023177095276,-0.3778468154185462,-0.36726339906613964,-0.3566799827137331}
#define d_CLde {0.307844559886235,0.3139230198379101,0.3197154500111718,0.3252526572503578,0.33056544839980484,0.33568463030385026,0.34064100980683176,0.3454653937530864,0.35018858898695154,0.35484140235276423,0.35945464069486216,0.3640591108575824,0.36868561968526226,0.373364974022239,0.3781278747383978,0.3829572489660009,0.3877130218373679,0.39223559310386064,0.3963824229295535,0.4001718619410713,0.40371067038340475,0.4070546553345904,0.4100006703747274,0.4122649171359812,0.4135286046368574,0.4132278501058644,0.41064825679954386,0.40339364783874804,0.3873881193466855,0.36446721821468625,0.3397687181340031,0.3159940063863457,0.29458000088650843,0.27553783634235113,0.2587491400655817,0.2440955393679079}
#define d_CmM {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,-9.560815312029521e-05,-0.00019681003256176018,-0.00029801191200322515,-0.0003992137914446901,-0.000500415670886155,-0.00060161755032762,-0.0007028194297690849,-0.0008040213092105503,-0.0009052231886520148,-0.0010064250680934795,-0.0011076269475349448,-0.0012088288269764102,-0.0013100307064178747,-0.0014112325858593392,-0.0015124344653008046,-0.00161363634474227,-0.0017148382241837345,-0.0018160401036251992,-0.0019172419830666644,-0.00201844386250813,-0.0021331218479256294,-0.006662712162585601,-0.011192302477245604,-0.015721892791905605,-0.024748364761256903,-0.040268298595628874,-0.05578823243000096,-0.07130816626437303,-0.09883705281405579,-0.13391253753046684,-0.16898802224687814,-0.20406350696328945,-0.2768152998838925,-0.34744998081556966,-0.36950708685474104,-0.2693820864264927,-0.13469104321324635,0.0}
#define d_rnd_aoa {-1.0,-0.6173913043478259,-0.23478260869565226,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0434782608695663,0.5217391304347831,1.0}
#define d_Cnb {-0.07,-0.07074257425742575,-0.0714851485148515,-0.07222772277227724,-0.07297029702970298,-0.07371287128712872,-0.07445544554455447,-0.07519801980198021,-0.07594059405940594,-0.07668316831683168,-0.07742574257425744,-0.07816831683168317,-0.07891089108910891,-0.07965346534653465,-0.08101838755304103,-0.08292786421499293,-0.08483734087694483,-0.08674681753889675,-0.08865629420084865,-0.09056577086280057,-0.09247524752475247,-0.09438472418670439,-0.0956039603960396,-0.0964950495049505,-0.09738613861386139,-0.09827722772277228,-0.09916831683168317,-0.1,-0.1,-0.1,-0.09725247524752476,-0.09391089108910891,-0.09056930693069307,-0.08722772277227724,-0.08262376237623761,-0.07549504950495049,-0.06836633663366337,-0.06123762376237625,-0.05410891089108912,-0.046980198019802,-0.04113861386138612,-0.035792079207920775,-0.030445544554455438,-0.025099009900990094,-0.019752475247524756,-0.014702970297029707,-0.012029702970297037,-0.009356435643564346,-0.006683168316831675,-0.004009900990099005,-0.0013366336633663344,0.0013366336633663352,0.004009900990099006,0.006683168316831676,0.009356435643564368,0.012029702970297039,0.014702970297029709,0.019752475247524756,0.025099009900990097,0.030445544554455438,0.03579207920792078,0.04113861386138616,0.046980198019802,0.05410891089108912,0.06123762376237625,0.06836633663366337,0.07549504950495049,0.08262376237623761,0.08722772277227725,0.09056930693069308,0.09391089108910892,0.09725247524752476,0.1,0.1,0.1,0.09916831683168317,0.09827722772277228,0.09738613861386139,0.0964950495049505,0.09560396039603959,0.09438472418670438,0.09247524752475246,0.09056577086280056,0.08865629420084865,0.08674681753889674,0.08483734087694483,0.08292786421499293,0.08101838755304103,0.07965346534653465,0.07891089108910891,0.07816831683168317,0.07742574257425744,0.0766831683168317,0.07594059405940594,0.0751980198019802,0.07445544554455445,0.07371287128712871,0.07297029702970297,0.07222772277227724,0.0714851485148515,0.07074257425742575,0.07}

#define d_CL_ail {1.0,0.9999420023652138,0.9998840047304275,0.9998260070956413,0.9997680094608551,0.9997100118260688,0.9996520141912826,0.9995940165564963,0.9995360189217101,0.9994780212869239,0.9994200236521376,0.9993620260173514,0.9993040283825652,0.9992460307477788,0.9991880331129926,0.9991300354782064,0.9990720378434201,0.9990140402086339,0.9989560425738477,0.9988980449390614,0.9988400473042752,0.9987820496694889,0.9955759973352578,0.973980810339818,0.9215687360999631,0.8021442002917654,0.6580332716918021,0.5139223430918385,0.41463045589155795,0.38164765753023205,0.348664859168906,0.33536759839243496,0.3237821234929078,0.3121966485933806,0.30061117369385343,0.28902569879432627,0.2774402238947991,0.26585474899527184,0.2542692740957447,0.24268379919621746,0.2310983242966903,0.21951284939716315,0.20792737449763596,0.19634189959810877,0.18475642469858153,0.17317094979905434,0.16158547489952718,0.15}
#define d_CD_ail {1.0,1.0000579976393802,1.0001159952787606,1.0001739929181408,1.0002319905575212,1.0002899881969014,1.0003479858362818,1.000405983475662,1.0004639811150422,1.0005219787544226,1.0005799763938028,1.0006379740331832,1.0006959716725634,1.0007539693119438,1.000811966951324,1.0008699645907042,1.0009279622300846,1.0009859598694648,1.0010439575088452,1.0011019551482254,1.0011599527876058,1.001217950426986,1.004424002713372,1.0260191895188349,1.0784312638899145,1.197855799787269,1.3419667283567958,1.4860776569263228,1.5931355521363952,1.6453740490716489,1.6976125460069027,1.7498510429421565,1.800531914893617,1.8138297872340425,1.827127659574468,1.8404255319148937,1.8537234042553192,1.8670212765957448,1.8803191489361701,1.8936170212765957,1.9069148936170213,1.9202127659574468,1.9335106382978724,1.9468085106382977,1.9601063829787235,1.9734042553191489,1.9867021276595744,2.0}

// (lower stall) #define d_CL_hstab_alpha {0.0,-0.0326939843067566,-0.06538796861351368,-0.09808195292027028,-0.13077593722702688,-0.16346992153378395,-0.19616390584054055,-0.22885789014729718,-0.26155187445405426,-0.28689980302992996,-0.31014885853983976,-0.3333979140497499,-0.3566469695596597,-0.3798960250695695,-0.4031450805794796,-0.4263941360893894,-0.4496431915992992,-0.47289224710920935,-0.49614130261911915,-0.5193903581290289,-0.5426394136389388,-0.5658884691488488,-0.5891375246587587,-0.6052504117346847,-0.6205947883638739,-0.635939164993063,-0.6512835416222521,-0.6666279182514415,-0.6819722948806306,-0.6973166715098198,-0.7126610481390091,-0.7280054247681982,-0.7433498013973874,-0.7586941780265767,-0.7740385546557658,-0.7893829312849551,-0.8047273079141443,-0.8200716845433333,-0.833042720095946,-0.843504795081892,-0.8539668700678379,-0.8644289450537839,-0.8748910200397298,-0.8855419936,-0.8965480964800001,-0.9075541993600001,-0.9125225225225225,-0.9157657657657658,-0.9190090090090091,-0.9222522522522523,-0.9254954954954956,-0.9287387387387388,-0.9291081081081082,-0.9276486486486487,-0.9261891891891892,-0.9247297297297298,-0.9232702702702703,-0.9183363201903904,-0.9095191158876876,-0.9007019115849849,-0.8918847072822823,-0.8830675029795796,-0.8730044560635134,-0.862716749004054,-0.8524290419445946,-0.8507862407862409,-0.8684766584766586,-0.9440990990990994,-0.9832432432432432,-0.9974974974954953,-0.979479479463063,-0.9614614614306306,-0.941891891847567,-0.8959459459037835,-0.84999999996,-0.8040540540162158,-0.7581081080724321,-0.7121621621286486,-0.6662162161848644,-0.6202702702410808,-0.5743243242972973,-0.528378378353513,-0.48243243240972944,-0.4364864864659459,-0.3905405405221617,-0.34459459457837804,-0.2986486486345945,-0.2527027026908103,-0.20675675674702676,-0.1608108108032431,-0.1148648648594589,-0.06891891891567536,-0.022972972971891825,0.022972972971892453,0.06891891891567602,0.11486486485945958,0.16081081080324383,0.20675675674702737,0.25270270269081097,0.2986486486345945,0.34459459457837877,0.3905405405221623,0.4364864864659459,0.4824324324097301,0.5283783783535136,0.5743243242972973,0.6202702702410815,0.666216216184865,0.7121621621286486,0.7581081080724329,0.8040540540162164,0.84999999996,0.8959459459037842,0.9418918918475678,0.9614614614306306,0.9794794794630632,0.9974974974954955,0.9832432432432432,0.9440990990990982,0.8684766584766583,0.8507862407862408,0.8524290419445947,0.8627167490040542,0.8730044560635135,0.8830675029795797,0.8918847072822823,0.900701911584985,0.9095191158876877,0.9183363201903905,0.9232702702702703,0.9247297297297298,0.9261891891891892,0.9276486486486487,0.9291081081081082,0.9287387387387388,0.9254954954954955,0.9222522522522523,0.9190090090090091,0.9157657657657657,0.9125225225225225,0.9075541993599999,0.89654809648,0.8855419936,0.8748910200397298,0.8644289450537836,0.8539668700678377,0.8435047950818918,0.8330427200959459,0.8200716845433333,0.8047273079141443,0.7893829312849547,0.7740385546557655,0.7586941780265765,0.7433498013973874,0.7280054247681982,0.7126610481390091,0.6973166715098195,0.6819722948806304,0.6666279182514412,0.6512835416222521,0.635939164993063,0.6205947883638738,0.6052504117346843,0.5891375246587583,0.5658884691488485,0.5426394136389388,0.5193903581290289,0.49614130261911915,0.4728922471092087,0.4496431915992989,0.4263941360893891,0.4031450805794793,0.3798960250695695,0.3566469695596597,0.3333979140497492,0.3101488585398394,0.2868998030299296,0.26155187445405376,0.22885789014729718,0.19616390584054055,0.163469921533783,0.1307759372270264,0.0980819529202698,0.0653879686135132,0.0326939843067566,0.0}
#define d_CL_hstab_alpha {0.0,0.029134532992288176,0.05826906598457546,0.08740359897686363,0.1165381319691518,0.14567266496144,0.17480719795372726,0.20394173094601545,0.2330762639383036,0.2622107969305909,0.29134532992287904,0.3204798629151672,0.3496143959074545,0.3787489288997427,0.4078834618920309,0.437017994884319,0.4661525278766063,0.4952870608688945,0.5244215938611827,0.5535561268534709,0.5826906598457581,0.6118251928380463,0.6409597258303344,0.6700942588226217,0.6992287918149099,0.7283633248071981,0.756469580163496,0.7701799486159382,0.7838903170683805,0.7976006855208229,0.7877840616966583,0.7634035989717223,0.7017069408740346,0.683784061696658,0.68,0.6875346214487147,0.6953627995772496,0.7031909777057841,0.7102125844347901,0.7169218195813197,0.7236310547278492,0.7303402898743787,0.7370495250209084,0.7389532133676092,0.7400637532133676,0.741174293059126,0.7422848329048843,0.7433953727506427,0.7428757497857755,0.740407883461868,0.7379400171379605,0.7354721508140531,0.7330042844901457,0.7305364181662382,0.7280685518423308,0.7198578102159383,0.7114829864380462,0.703220278090617,0.6952594189790489,0.6872985598674807,0.6793377007559125,0.6713768416443445,0.6634159825327763,0.6496171600760924,0.6349309671909511,0.6202447743058098,0.6055585814206683,0.5908723885355267,0.5761861956503858,0.5615000027652441,0.5468138098801026,0.5321276169949614,0.5174414241098201,0.5027552312246786,0.4880690383395373,0.4733828454543958,0.45698200514138815,0.43754755784061705,0.4181131105398457,0.3986786632390746,0.3792442159383032,0.3598097686375321,0.34037532133676074,0.32094087403598964,0.30150642673521855,0.2800822622107968,0.2578714652956298,0.2356606683804625,0.21344987146529557,0.19123907455012829,0.1690282776349613,0.14681748071979436,0.12460668380462708,0.10226221079691515,0.07820051413881725,0.05413881748071972,0.03007712082262219,0.006015424164524288,-0.022557840616966553,-0.05263496143958893,-0.08271208226221084,-0.11278920308483323,-0.14187660668380475,-0.16964010282776343,-0.19740359897172255,-0.22516709511568123,-0.25293059125964035,-0.280694087403599,-0.30845758354755815,-0.3362210796915168,-0.3639845758354755,-0.3890295629820053,-0.41332262210796916,-0.4376156812339334,-0.46190874035989726,-0.48620179948586145,-0.5104948586118253,-0.5347879177377892,-0.5590809768637534,-0.5825496862642674,-0.6009074273669924,-0.6192651684697172,-0.637622909572442,-0.6559806506751672,-0.674338391777892,-0.6926961328806172,-0.711053873983342,-0.729411615086067,-0.7477693561887919,-0.7661270972915167,-0.7844848383942418,-0.8028425794969667,-0.8212003205996917,-0.8342455150636248,-0.8441965889577122,-0.8541476628517995,-0.8640987367458869,-0.8740498106399744,-0.8841194681634962,-0.8945879978951158,-0.9050565276267355,-0.9116281062553556,-0.91471293916024,-0.9177977720651244,-0.9208826049700086,-0.923967437874893,-0.9270522707797773,-0.9299383033419023,-0.9285501285347044,-0.9271619537275064,-0.9257737789203084,-0.9243856041131105,-0.9229974293059126,-0.9171186343062552,-0.9087320903679521,-0.9003455464296487,-0.8919590024913453,-0.8835724585530418,-0.874096110782905,-0.8643108881299485,-0.8545256654769922,-0.85,-0.8631432577705072,-0.9156940874035997,-0.97547557840617,-0.9939845758354755,-0.9884318765974291,-0.971293916001028,-0.9541559554046273,-0.9286632390308482,-0.8922450727943441,-0.8558269065578399,-0.8194087403213368,-0.7829905740848326,-0.7465724078483285,-0.7101542416118254,-0.6737360753753212,-0.637317909138817,-0.6008997429023129,-0.5644815766658098,-0.5280634104293056,-0.49164524419280137,-0.4552270779562983,-0.4188089117197942,-0.38239074548329,-0.3459725792467857,-0.30955441301028275,-0.27313624677377857,-0.23671808053727428,-0.20029991430077132,-0.16388174806426714,-0.12746358182776285,-0.09104541559125989,-0.054627249354755714,-0.018209083118251423,0.01820908311825265,0.054627249354755714,0.09104541559125989,0.12746358182776407,0.16388174806426714,0.20029991430077132,0.2367180805372755,0.2731362467737797,0.30955441301028275,0.3459725792467869,0.3823907454832911,0.4188089117197942,0.45522707795629835,0.49164524419280253,0.5280634104293067,0.5644815766658098,0.600899742902314,0.6373179091388181,0.6737360753753212,0.7101542416118254,0.7465724078483296,0.7829905740848337,0.8194087403213368,0.855826906557841,0.8922450727943452,0.9286632390308482,0.9541559554046273,0.9712939160010285,0.9884318765974297,0.9939845758354755,0.9754755784061694,0.9156940874035974,0.8631432577705072,0.85,0.8545256654769924,0.8643108881299488,0.874096110782905,0.8835724585530421,0.8919590024913455,0.9003455464296487,0.9087320903679521,0.9171186343062555,0.9229974293059126,0.9243856041131105,0.9257737789203085,0.9271619537275064,0.9285501285347044,0.9299383033419024,0.9270522707797771,0.923967437874893,0.9208826049700086,0.9177977720651243,0.9147129391602399,0.9116281062553556,0.9050565276267352,0.8945879978951154,0.8841194681634962,0.8740498106399742,0.8640987367458868,0.8541476628517993,0.8441965889577121,0.8342455150636247,0.8212003205996912,0.8028425794969667,0.7844848383942415,0.7661270972915164,0.7477693561887914,0.7294116150860668,0.7110538739833416,0.6926961328806166,0.674338391777892,0.655980650675167,0.6376229095724418,0.6192651684697167,0.6009074273669922,0.5825496862642671,0.5590809768637527,0.5347879177377892,0.510494858611825,0.48620179948586073,0.4619087403598965,0.437615681233933,0.41332262210796955,0.38902956298200453,0.36398457583547555,0.33622107969151555,0.3084575835475573,0.280694087403599,0.25293059125963907,0.2251670951156808,0.19740359897172255,0.16964010282776257,0.1418766066838043,0.11278920308483323,0.08271208226220991,0.05263496143958847,0.022557840616967015,-0.006015424164525029,-0.03007712082262219,-0.05413881748072083,-0.07820051413881798,-0.10226221079691515,-0.12460668380462811,-0.14681748071979472,-0.16902827763496134,-0.1912390745501293,-0.21344987146529593,-0.2356606683804625,-0.2578714652956305,-0.28008226221079713,-0.30150642673521827,-0.32094087403599025,-0.340375321336761,-0.35980976863753183,-0.3792442159383038,-0.3986786632390746,-0.41811311053984657,-0.4375475578406174,-0.45698200514138815,-0.47338284545439646,-0.4880690383395375,-0.5027552312246786,-0.5174414241098205,-0.5321276169949616,-0.5468138098801026,-0.5615000027652446,-0.5761861956503858,-0.5908723885355267,-0.6055585814206688,-0.6202447743058098,-0.6349309671909518,-0.6496171600760928,-0.6634159825327763,-0.6713768416443447,-0.6793377007559127,-0.6872985598674807,-0.6952594189790492,-0.7032202780906172,-0.7114829864380462,-0.7198578102159385,-0.7280685518423308,-0.7305364181662382,-0.7330042844901458,-0.7354721508140531,-0.7379400171379606,-0.7404078834618681,-0.7428757497857755,-0.7433953727506426,-0.7422848329048843,-0.741174293059126,-0.7400637532133676,-0.7389532133676092,-0.7370495250209084,-0.7303402898743785,-0.7236310547278492,-0.7169218195813197,-0.71021258443479,-0.7031909777057841,-0.6953627995772496,-0.6875346214487145,-0.68,-0.6837840616966588,-0.7017069408740366,-0.7634035989717223,-0.7877840616966587,-0.7976006855208224,-0.7838903170683805,-0.7701799486159379,-0.756469580163496,-0.7283633248071981,-0.699228791814909,-0.6700942588226219,-0.6409597258303346,-0.6118251928380455,-0.5826906598457582,-0.5535561268534691,-0.5244215938611818,-0.49528706086889457,-0.4661525278766055,-0.4370179948843182,-0.40788346189203095,-0.3787489288997419,-0.3496143959074546,-0.3204798629151673,-0.2913453299228782,-0.26221079693059096,-0.23307626393830372,-0.20394173094601464,-0.17480719795372734,-0.14567266496144005,-0.11653813196915097,-0.08740359897686367,-0.0582690659845746,-0.0291345329922873,0.0}
#define d_CD_hstab_alpha {0.0,0.0037854889589904895,0.0075709779179810735,0.013391167192429141,0.022854889589905364,0.03231861198738159,0.046190851735015775,0.061805993690851935,0.0774211356466877,0.0939747634069398,0.11441640378548897,0.13485804416403813,0.15529968454258675,0.1757413249211354,0.20157728706624606,0.22883280757097826,0.2560883280757098,0.2833438485804413,0.3119242902208202,0.3425867507886439,0.3732492113564669,0.4039116719242899,0.43457413249211363,0.47195583596214563,0.5094321766561515,0.5469085173501573,0.5843848580441641,0.6245110410094643,0.6665299684542587,0.7085488958990531,0.7505678233438486,0.792586750788644,0.8346056782334386,0.876624605678233,0.9186435331230285,0.9606624605678239,0.9991482649842272,1.0366246056782331,1.0741009463722397,1.1115772870662466,1.1490536277602525,1.1865299684542583,1.2240063091482651,1.261482649842272,1.2989589905362777,1.3276025236593056,1.3559936908517352,1.3843848580441642,1.412776025236593,1.4411671924290221,1.4695583596214512,1.4979495268138803,1.5263406940063093,1.552839116719243,1.5698738170347004,1.5869085173501578,1.6039432176656152,1.6209779179810726,1.63801261829653,1.6550473186119874,1.6720820189274448,1.6891167192429022,1.7041009463722396,1.7154574132492113,1.726813880126183,1.7381703470031546,1.7495268138801263,1.7608832807570978,1.7722397476340694,1.7835962145110411,1.7949526813880128,1.8031545741324921,1.808832807570978,1.8145110410094638,1.8201892744479495,1.8258675078864355,1.8315457413249212,1.837223974763407,1.8429022082018929,1.8485804416403786,1.8457413249211356,1.84006309148265,1.8343848580441642,1.8287066246056782,1.8230283911671925,1.8173501577287066,1.8116719242902208,1.8059936908517351,1.8003154574132492,1.7892744479495268,1.7779179810725552,1.7665615141955835,1.755205047318612,1.7438485804416404,1.7324921135646687,1.721135646687697,1.7097791798107256,1.6976340694006309,1.6805993690851735,1.663564668769716,1.6465299684542587,1.6294952681388013,1.612460567823344,1.5954258675078863,1.578391167192429,1.5613564668769715,1.5405362776025235,1.5121451104100945,1.4837539432176656,1.4553627760252366,1.4269716088328075,1.3985804416403784,1.3701892744479494,1.3417981072555207,1.3134069400630914,1.2802208201892737,1.242744479495268,1.205268138801262,1.1677917981072554,1.1303154574132486,1.0928391167192428,1.0553627760252369,1.01788643533123,0.9804100946372233,0.9355520504731859,0.8878548895899057,0.8401577287066244,0.792460567823343,0.7447634069400628,0.6970662460567827,0.6493690851735013,0.60167192429022,0.5539747634069399,0.5062776025236597,0.45858044164037837,0.410883280757097,0.36318611987381677,0.31519716088328115,0.2669321766561512,0.21866719242902122,0.1704022082018925,0.1446608832807573,0.11910883280757084,0.0935567823343844,0.07466876971608827,0.06331230283911679,0.05195583596214505,0.040599369085173295,0.029810725552050457,0.026971608832807588,0.024132492113564653,0.021293375394321714,0.018454258675078848,0.01561514195583598,0.012776025236593044,0.009936908517350105,0.007097791798107238,0.004258675078864372,0.001419558359621433,0.0014195583596215045,0.004258675078864372,0.007097791798107238,0.009936908517350176,0.012776025236593113,0.01561514195583598,0.018454258675078848,0.021293375394321787,0.024132492113564722,0.026971608832807588,0.029810725552050457,0.04059936908517357,0.05195583596214533,0.06331230283911679,0.07466876971608827,0.09355678233438504,0.11910883280757148,0.14466088328075727,0.1704022082018925,0.21866719242902244,0.2669321766561524,0.3151971608832811,0.3631861198738168,0.4108832807570982,0.45858044164037953,0.5062776025236597,0.5539747634069399,0.6016719242902212,0.6493690851735026,0.6970662460567827,0.7447634069400628,0.7924605678233443,0.8401577287066255,0.8878548895899057,0.9355520504731859,0.9804100946372243,1.0178864353312311,1.0553627760252369,1.0928391167192428,1.1303154574132495,1.1677917981072563,1.2052681388012623,1.242744479495268,1.2802208201892749,1.313406940063092,1.3417981072555207,1.3701892744479494,1.3985804416403789,1.4269716088328082,1.455362776025237,1.4837539432176656,1.512145110410095,1.5405362776025244,1.5613564668769717,1.578391167192429,1.5954258675078865,1.6124605678233441,1.6294952681388013,1.6465299684542587,1.663564668769716,1.680599369085174,1.697634069400631,1.7097791798107256,1.7211356466876973,1.732492113564669,1.7438485804416404,1.755205047318612,1.7665615141955835,1.7779179810725554,1.789274447949527,1.8003154574132492,1.8059936908517353,1.811671924290221,1.8173501577287068,1.8230283911671925,1.8287066246056782,1.8343848580441642,1.84006309148265,1.8457413249211356,1.8485804416403784,1.8429022082018927,1.837223974763407,1.8315457413249212,1.8258675078864355,1.8201892744479495,1.8145110410094638,1.808832807570978,1.803154574132492,1.7949526813880123,1.783596214511041,1.7722397476340694,1.760883280757098,1.7495268138801259,1.7381703470031544,1.726813880126183,1.7154574132492109,1.7041009463722394,1.689116719242902,1.6720820189274448,1.6550473186119876,1.6380126182965296,1.6209779179810724,1.6039432176656152,1.5869085173501571,1.5698738170347,1.5528391167192428,1.5263406940063093,1.4979495268138805,1.4695583596214505,1.441167192429022,1.412776025236593,1.3843848580441631,1.3559936908517343,1.3276025236593056,1.2989589905362777,1.2614826498422718,1.224006309148264,1.1865299684542583,1.1490536277602525,1.1115772870662446,1.0741009463722389,1.0366246056782331,0.9991482649842272,0.9606624605678239,0.9186435331230274,0.876624605678233,0.8346056782334386,0.7925867507886419,0.7505678233438475,0.7085488958990531,0.6665299684542587,0.6245110410094643,0.5843848580441631,0.5469085173501573,0.5094321766561515,0.47195583596214374,0.4345741324921128,0.40391167192428984,0.3732492113564669,0.3425867507886439,0.3119242902208194,0.2833438485804413,0.2560883280757098,0.2288328075709769,0.2015772870662454,0.1757413249211354,0.15529968454258675,0.13485804416403813,0.11441640378548845,0.09397476340693982,0.0774211356466877,0.06180599369085116,0.04619085173501539,0.03231861198738159,0.022854889589905367,0.013391167192429144,0.007570977917980978,0.0037854889589904886,0.0}

#define d_CL_vstab_aoa {0.0,0.049774635438904126,0.09954927087780825,0.14932390631671238,0.1990985417556165,0.24887317719452062,0.29864781263342477,0.34842244807232886,0.398197083511233,0.4479717189501371,0.49774635438904125,0.5475209898279454,0.5972956252668495,0.6470702607057536,0.6968448961446577,0.7466195315835619,0.7771394903301372,0.7915942455812787,0.7947680070728766,0.7744056562213697,0.7262167792434439,0.6845190749688355,0.6675504492756849,0.6545588452270549,0.6588010016380137,0.6650758580084932,0.682044483731233,0.6990131094539728,0.711268228031507,0.7206952423219177,0.7301222566123289,0.7395492709027396,0.7483870968,0.7483870968,0.7483870968,0.7483870968,0.7483870968,0.7460303432273974,0.7413168360821918,0.7366033289369864,0.7318898217917807,0.7271763146465755,0.7224628075013699,0.7177493003561645,0.713035793210959,0.7083222860657535,0.7021947267769865,0.6937104139156165,0.6852261010542466,0.6767417881928768,0.6682574753315069,0.658563362304475,0.6461197034463928,0.6336760445883106,0.6212323857302284,0.6087887268721461,0.596345068014064,0.5839014091559818,0.5714577502978996,0.5590140914398174,0.5465704325817352,0.534126773723653,0.5216831148655708,0.5092394560074887,0.49679579714940647,0.4843521382913243,0.47146855209917815,0.45449992637643843,0.43753130065369866,0.42056267493095895,0.40359404920821923,0.38662542348547946,0.36965679776273974,0.35268817204,0.3357195463172603,0.31875092059452054,0.3017822948717808,0.28481366914904105,0.26784504342630133,0.2508764177035616,0.23390779198082187,0.2169391662580824,0.19619973482794542,0.17498895268438378,0.1537781705408221,0.13256738839726045,0.11135660625369881,0.09014582411013716,0.06893504196657552,0.04772425982301384,0.026513477679452196,0.00530269553589055,-0.019885108263287488,-0.04639858594767106,-0.07291206363205463,-0.0994255413164382,-0.12593901900082177,-0.15245249668520533,-0.17896597436958891,-0.20547945205397247,-0.23199292973835606,-0.2585064074227396,-0.2817793489473059,-0.3029901310974429,-0.3242009132475799,-0.3454116953977169,-0.3666224775478538,-0.3878332596979908,-0.4090440418481278,-0.4302548239982648,-0.4514656061484018,-0.4726763882985388,-0.49388717044867547,-0.5150979525988124,-0.5363087347489495,-0.5575195168990865,-0.5787302990492235,-0.5976628860765295,-0.6132174596458445,-0.6287720332151596,-0.6443266067844747,-0.6598811803537898,-0.6754357539231048,-0.69099032749242,-0.7065449010617351,-0.7220994746310501,-0.7376540482003652,-0.7532086217696803,-0.7687631953389954,-0.7843177689083104,-0.7998723424776255,-0.8154269160469406,-0.8300191485769863,-0.8406245396586302,-0.851229930740274,-0.8618353218219178,-0.8724407129035616,-0.8824569155917809,-0.8883487995260274,-0.894240683460274,-0.9001325673945205,-0.9060244513287671,-0.9119163352630136,-0.9178082191972603,-0.9237001031315069,-0.9295919870657534,-0.935483871,-0.935483871,-0.935483871,-0.935483871,-0.935483871,-0.9303284725575341,-0.918544704689041,-0.9067609368205479,-0.8949771689520547,-0.8831934010835616,-0.8631609957071232,-0.8419502135438356,-0.8261525997585617,-0.8208499042571917,-0.8238326705229453,-0.8450434526763694,-0.8774698567342452,-0.9380720914301356,-0.9807335395589035,-0.9965630677146121,-0.9824225463118724,-0.9555162763136993,-0.9021652673063026,-0.8399469730093163,-0.77772867871233,-0.7155103844153436,-0.6532920901183574,-0.591073795821371,-0.5288555015243848,-0.4666372072273984,-0.4044189129304121,-0.34220061863342577,-0.27998232433643944,-0.2177640300394531,-0.15554573574246677,-0.09332744144548044,-0.03110914714849411,0.031109147148492267,0.0933274414454786,0.1555457357424649,0.21776403003945125,0.27998232433643755,0.3422006186334239,0.4044189129304102,0.46663720722739654,0.5288555015243829,0.5910737958213692,0.6532920901183555,0.7155103844153419,0.7777286787123282,0.8399469730093145,0.9021652673063009,0.9555162763136984,0.982422546311872,0.9965630677146118,0.9807335395589043,0.9380720914301374,0.8774698567342469,0.8450434526763699,0.8238326705229453,0.8208499042571917,0.8261525997585617,0.8419502135438356,0.8631609957071232,0.8831934010835616,0.8949771689520547,0.9067609368205479,0.918544704689041,0.9303284725575341,0.935483871,0.935483871,0.935483871,0.935483871,0.935483871,0.9295919870657534,0.9237001031315069,0.9178082191972603,0.9119163352630136,0.9060244513287673,0.9001325673945207,0.8942406834602741,0.8883487995260275,0.882456915591781,0.872440712903562,0.8618353218219181,0.8512299307402743,0.8406245396586304,0.8300191485769866,0.8154269160469411,0.799872342477626,0.7843177689083108,0.7687631953389958,0.7532086217696807,0.7376540482003656,0.7220994746310505,0.7065449010617355,0.6909903274924204,0.6754357539231053,0.6598811803537903,0.6443266067844752,0.6287720332151601,0.613217459645845,0.5976628860765298,0.578730299049224,0.5575195168990871,0.5363087347489501,0.5150979525988131,0.4938871704486761,0.4726763882985391,0.45146560614840214,0.4302548239982651,0.40904404184812815,0.38783325969799115,0.36662247754785415,0.34541169539771716,0.32420091324758077,0.30299013109744316,0.2817793489473068,0.25850640742274,0.23199292973835722,0.2054794520539729,0.17896597436959005,0.15245249668520572,0.12593901900082294,0.0994255413164386,0.0729120636320558,0.04639858594767146,0.019885108263288653,-0.005302695535890261,-0.0265134776794513,-0.047724259823013565,-0.0689350419665746,-0.09014582411013687,-0.1113566062536979,-0.13256738839726018,-0.1537781705408212,-0.17498895268438347,-0.19619973482794453,-0.21693916625808213,-0.23390779198082137,-0.2508764177035616,-0.26784504342630083,-0.28481366914904105,-0.3017822948717803,-0.31875092059452054,-0.33571954631725975,-0.35268817204,-0.36965679776273924,-0.38662542348547946,-0.40359404920821873,-0.42056267493095895,-0.43753130065369816,-0.45449992637643843,-0.47146855209917765,-0.4843521382913243,-0.4967957971494061,-0.5092394560074887,-0.5216831148655705,-0.534126773723653,-0.5465704325817349,-0.5590140914398174,-0.5714577502978992,-0.5839014091559818,-0.5963450680140636,-0.6087887268721461,-0.621232385730228,-0.6336760445883105,-0.6461197034463924,-0.658563362304475,-0.6682574753315067,-0.6767417881928768,-0.6852261010542464,-0.6937104139156165,-0.7021947267769861,-0.7083222860657535,-0.7130357932109589,-0.7177493003561642,-0.7224628075013698,-0.7271763146465752,-0.7318898217917807,-0.7366033289369861,-0.7413168360821918,-0.7460303432273971,-0.7483870968,-0.7483870968,-0.7483870968,-0.7483870968,-0.7483870968,-0.7395492709027401,-0.7301222566123289,-0.7206952423219183,-0.711268228031507,-0.6990131094539733,-0.682044483731233,-0.6650758580084938,-0.6588010016380137,-0.654558845227055,-0.6675504492756849,-0.684519074968835,-0.7262167792434439,-0.7744056562213691,-0.7947680070728766,-0.791594245581279,-0.7771394903301372,-0.7466195315835633,-0.6968448961446577,-0.647070260705755,-0.5972956252668495,-0.5475209898279468,-0.49774635438904125,-0.4479717189501386,-0.398197083511233,-0.3484224480723303,-0.29864781263342477,-0.24887317719452207,-0.19909854175561648,-0.14932390631671388,-0.0995492708778083,-0.04977463543890559,0.0}
#define d_CD_vstab_alpha {0.0,0.0037854889589904895,0.0075709779179810735,0.013391167192429141,0.022854889589905364,0.03231861198738159,0.046190851735015775,0.061805993690851935,0.0774211356466877,0.0939747634069398,0.11441640378548897,0.13485804416403813,0.15529968454258675,0.1757413249211354,0.20157728706624606,0.22883280757097826,0.2560883280757098,0.2833438485804413,0.3119242902208202,0.3425867507886439,0.3732492113564669,0.4039116719242899,0.43457413249211363,0.47195583596214563,0.5094321766561515,0.5469085173501573,0.5843848580441641,0.6245110410094643,0.6665299684542587,0.7085488958990531,0.7505678233438486,0.792586750788644,0.8346056782334386,0.876624605678233,0.9186435331230285,0.9606624605678239,0.9991482649842272,1.0366246056782331,1.0741009463722397,1.1115772870662466,1.1490536277602525,1.1865299684542583,1.2240063091482651,1.261482649842272,1.2989589905362777,1.3276025236593056,1.3559936908517352,1.3843848580441642,1.412776025236593,1.4411671924290221,1.4695583596214512,1.4979495268138803,1.5263406940063093,1.552839116719243,1.5698738170347004,1.5869085173501578,1.6039432176656152,1.6209779179810726,1.63801261829653,1.6550473186119874,1.6720820189274448,1.6891167192429022,1.7041009463722396,1.7154574132492113,1.726813880126183,1.7381703470031546,1.7495268138801263,1.7608832807570978,1.7722397476340694,1.7835962145110411,1.7949526813880128,1.8031545741324921,1.808832807570978,1.8145110410094638,1.8201892744479495,1.8258675078864355,1.8315457413249212,1.837223974763407,1.8429022082018929,1.8485804416403786,1.8457413249211356,1.84006309148265,1.8343848580441642,1.8287066246056782,1.8230283911671925,1.8173501577287066,1.8116719242902208,1.8059936908517351,1.8003154574132492,1.7892744479495268,1.7779179810725552,1.7665615141955835,1.755205047318612,1.7438485804416404,1.7324921135646687,1.721135646687697,1.7097791798107256,1.6976340694006309,1.6805993690851735,1.663564668769716,1.6465299684542587,1.6294952681388013,1.612460567823344,1.5954258675078863,1.578391167192429,1.5613564668769715,1.5405362776025235,1.5121451104100945,1.4837539432176656,1.4553627760252366,1.4269716088328075,1.3985804416403784,1.3701892744479494,1.3417981072555207,1.3134069400630914,1.2802208201892737,1.242744479495268,1.205268138801262,1.1677917981072554,1.1303154574132486,1.0928391167192428,1.0553627760252369,1.01788643533123,0.9804100946372233,0.9355520504731859,0.8878548895899057,0.8401577287066244,0.792460567823343,0.7447634069400628,0.6970662460567827,0.6493690851735013,0.60167192429022,0.5539747634069399,0.5062776025236597,0.45858044164037837,0.410883280757097,0.36318611987381677,0.31519716088328115,0.2669321766561512,0.21866719242902122,0.1704022082018925,0.1446608832807573,0.11910883280757084,0.0935567823343844,0.07466876971608827,0.06331230283911679,0.05195583596214505,0.040599369085173295,0.029810725552050457,0.026971608832807588,0.024132492113564653,0.021293375394321714,0.018454258675078848,0.01561514195583598,0.012776025236593044,0.009936908517350105,0.007097791798107238,0.004258675078864372,0.001419558359621433,0.0014195583596215045,0.004258675078864372,0.007097791798107238,0.009936908517350176,0.012776025236593113,0.01561514195583598,0.018454258675078848,0.021293375394321787,0.024132492113564722,0.026971608832807588,0.029810725552050457,0.04059936908517357,0.05195583596214533,0.06331230283911679,0.07466876971608827,0.09355678233438504,0.11910883280757148,0.14466088328075727,0.1704022082018925,0.21866719242902244,0.2669321766561524,0.3151971608832811,0.3631861198738168,0.4108832807570982,0.45858044164037953,0.5062776025236597,0.5539747634069399,0.6016719242902212,0.6493690851735026,0.6970662460567827,0.7447634069400628,0.7924605678233443,0.8401577287066255,0.8878548895899057,0.9355520504731859,0.9804100946372243,1.0178864353312311,1.0553627760252369,1.0928391167192428,1.1303154574132495,1.1677917981072563,1.2052681388012623,1.242744479495268,1.2802208201892749,1.313406940063092,1.3417981072555207,1.3701892744479494,1.3985804416403789,1.4269716088328082,1.455362776025237,1.4837539432176656,1.512145110410095,1.5405362776025244,1.5613564668769717,1.578391167192429,1.5954258675078865,1.6124605678233441,1.6294952681388013,1.6465299684542587,1.663564668769716,1.680599369085174,1.697634069400631,1.7097791798107256,1.7211356466876973,1.732492113564669,1.7438485804416404,1.755205047318612,1.7665615141955835,1.7779179810725554,1.789274447949527,1.8003154574132492,1.8059936908517353,1.811671924290221,1.8173501577287068,1.8230283911671925,1.8287066246056782,1.8343848580441642,1.84006309148265,1.8457413249211356,1.8485804416403784,1.8429022082018927,1.837223974763407,1.8315457413249212,1.8258675078864355,1.8201892744479495,1.8145110410094638,1.808832807570978,1.803154574132492,1.7949526813880123,1.783596214511041,1.7722397476340694,1.760883280757098,1.7495268138801259,1.7381703470031544,1.726813880126183,1.7154574132492109,1.7041009463722394,1.689116719242902,1.6720820189274448,1.6550473186119876,1.6380126182965296,1.6209779179810724,1.6039432176656152,1.5869085173501571,1.5698738170347,1.5528391167192428,1.5263406940063093,1.4979495268138805,1.4695583596214505,1.441167192429022,1.412776025236593,1.3843848580441631,1.3559936908517343,1.3276025236593056,1.2989589905362777,1.2614826498422718,1.224006309148264,1.1865299684542583,1.1490536277602525,1.1115772870662446,1.0741009463722389,1.0366246056782331,0.9991482649842272,0.9606624605678239,0.9186435331230274,0.876624605678233,0.8346056782334386,0.7925867507886419,0.7505678233438475,0.7085488958990531,0.6665299684542587,0.6245110410094643,0.5843848580441631,0.5469085173501573,0.5094321766561515,0.47195583596214374,0.4345741324921128,0.40391167192428984,0.3732492113564669,0.3425867507886439,0.3119242902208194,0.2833438485804413,0.2560883280757098,0.2288328075709769,0.2015772870662454,0.1757413249211354,0.15529968454258675,0.13485804416403813,0.11441640378548845,0.09397476340693982,0.0774211356466877,0.06180599369085116,0.04619085173501539,0.03231861198738159,0.022854889589905367,0.013391167192429144,0.007570977917980978,0.0037854889589904886,0.0}

#define d_comp_e {1.0,0.9994871794871795,0.9989743589743589,0.9984615384615385,0.997948717948718,0.9974358974358974,0.9969230769230769,0.9964102564102564,0.9958974358974358,0.9953846153846154,0.9948717948717949,0.9943589743589744,0.9938461538461538,0.9933333333333333,0.9928205128205128,0.9923076923076923,0.9917948717948718,0.9912820512820513,0.9907692307692307,0.9902564102564102,0.9884615384615384,0.9853846153846154,0.9823076923076923,0.9792307692307692,0.9761538461538461,0.9730769230769231,0.97,0.9576923076923076,0.9453846153846154,0.933076923076923,0.9207692307692308,0.9084615384615384,0.8961538461538461,0.8766666666666667,0.85,0.8233333333333333,0.7966666666666666,0.77,0.7433333333333333,0.7166666666666666,0.69,0.6633333333333334,0.6366666666666667,0.6126923076923075,0.5896153846153845,0.5665384615384615,0.5434615384615384,0.5203846153846152,0.5057692307692307,0.4980769230769231,0.49038461538461536,0.48269230769230764,0.4825,0.4863461538461538,0.49057692307692313,0.5021153846153847,0.5136538461538462,0.5269230769230769,0.5423076923076924,0.5576923076923077,0.5719230769230769,0.5815384615384614,0.5911538461538461,0.6007692307692308,0.6103846153846154,0.62}

#define d_CDialpha {0.025, 0.2, 0.4}
#define c_CDialphaMin 0.297
#define c_CDialphaMax 0.454


#define c_fuelToHPOmegaMin 0.0997972712713
#define c_fuelToHPOmegaMax 1.0241051216
#define c_fuelToHPOmega {718.553684195,785.175442319,827.554786368,864.804956338,894.88535128,917.845674553,935.595993656,953.149496685,969.026172795,982.869071898,991.176826568,1000.28112533,1009.48520511,1018.19185491,1026.49704877,1034.80224263,1042.281103,1049.39524672,1056.50939044,1063.42833188,1069.99327847,1076.41951953,1081.91089534,1087.40227116,1092.89364697,1098.06651338,1102.87976024,1107.6930071,1112.50625396,1117.31950082,1121.78251606,1125.94172052,1130.10092498,1134.26012944,1138.4193339,1142.57853837,1146.7244457,1150.80379501,1154.88314433,1158.96249364,1163.04184295,1167.12119226,1171.20054157,1175.2800553,1179.50735225,1183.73464921,1187.96194616,1192.18924311,1196.41654007,1200.64383702,1204.6276804,1208.59892916,1212.57017792,1216.54142668,1220.51267544,1224.4839242,1228.38776614,1232.26797749,1236.14818884,1240.02840019,1243.90861154,1247.70106618,1251.31207141,1254.92307664,1258.53408187,1262.1531325,1266.07783469,1270.00253688,1273.92723907}

#define c_lpOmegaToMassFlowMin 368.309218417
#define c_lpOmegaToMassFlowMax 1145.51271365
#define c_lpOmegaToMassFlow {14.153846153846153,14.970167688681105,15.786489223516059,16.60281075835101,17.41913229318596,18.235453828020912,19.051775362855864,19.808255509016593,20.511118964860955,21.213982420705314,21.916845876549676,22.619709332394034,23.319501041438368,23.93434501910124,24.549188996764116,25.164032974426984,25.778876952089856,26.40863447795153,27.160744007045345,27.912853536139167,28.664963065232982,29.30318350753733,29.851368025287186,30.399552543037043,30.949201945420217,31.67339420993149,32.39758647444277,33.15152004050989,33.9602462822334,34.76835051118761,35.55644496552627,36.34453941986494,37.248933433059825,38.20118383909855,39.10151238220541,39.99657203213186,40.891948723221425,41.80873701240233,42.76382309808374,43.87676466105266,45.04998939778599,46.19699892777354,47.15186430370354,48.15781852930548,49.222834292825446,50.31366611953428,51.352058777622524,52.38882450669599,53.22400249903742,54.24649607880849,55.228715941284584,56.18718923850627,57.120180984813736,58.002532544749094,58.79095659608982,59.518177693853104,60.18814644858488,60.809556569371566,61.385304938337036,61.9128785050542,62.36995648988904,62.74653488358094,62.90319029883142,63.059845714081895}

#define c_hpOmegaToMassFlowMin 708.491812467
#define c_hpOmegaToMassFlowMax 1270.46797249
#define c_hpOmegaToMassFlow {14.153846153846153,14.674102474615989,15.194358795385817,15.714615116155652,16.234871436925488,16.755127757695323,17.27538407846515,17.795640399234983,18.31589672000482,18.836153040774654,19.347045629699178,19.8333645654062,20.31968350111322,20.80600243682024,21.29232137252726,21.778640308234284,22.264959243941306,22.75127817964833,23.293422297100697,23.849548669234377,24.405675041368053,24.96180141350172,25.517927785635397,26.109138232702424,26.756724437528437,27.404310642354442,28.05189684718046,28.6899376312764,29.318447970473933,29.946958309671473,30.581762050580313,31.23086116923534,31.879960287890366,32.6859936136943,33.64020903413957,34.59844183913087,35.559097372667665,36.55431480696329,37.544623116887145,38.43868050404504,39.41090412739851,40.48932625315562,41.57086158984418,42.672087524311266,43.81447314550522,45.026043995985006,46.16649694436004,47.17246280239374,48.22902320143724,49.40386637301014,50.59758998937458,51.675101831067934,52.72160281910497,53.76409353228914,54.83727528953653,55.91062256401598,56.867362241657965,57.74636912786565,58.574273080845366,59.351827150939684,60.028681137819675,60.655751631994576,61.234862731277204,61.7671910160962,62.24395687917939,62.62602736197649,62.90049539653679,63.07612616664443}

#define c_massFlowToStaticThrustMin 14.1538461538
#define c_massFlowToStaticThrustMax 63.0769230769
#define c_massFlowToStaticThrust {2.369493754109138,2.6924901716110505,3.0154865891129634,3.3384830066148754,3.807814407814408,4.290175636329482,4.772536864844557,5.254898093359631,5.871832441063209,6.569240161547853,7.266647882032497,8.051684103048865,9.019634184398452,9.98758426574804,10.955534347097622,11.96888794965718,12.986625340471495,14.04626016718324,15.218920634920634,16.391581102658026,17.55940640556025,18.722748191978962,19.88608997839767,21.111646473184933,22.561716915563068,24.0117873579412,25.497943082558464,27.04956325725557,28.935371466140687,30.66200995585611,32.319620550389786,33.93097586174508,35.716430919507836,37.74219028834413,40.08091669014745,43.77876397107166}

#define c_maxStaticThrust 43778.76397107166

#define c_windmillMin 25.0
#define c_windmillMax 375.0
#define c_windmill {0.0, 120.0, 180.0, 220.0, 270.0, 300.0, 340.0, 381.0}

#define c_fuelFlowMax c_fuelToHPOmegaMax
#define c_maxHPOmega c_hpOmegaToMassFlowMax
#define c_maxLPOmega c_lpOmegaToMassFlowMax

#define c_throttleIdle 0.55

#define c_startOmega 200.0

#define c_huskPlotMach0Min 0.477987421384
#define c_huskPlotMach0Max 1.00314465409
#define c_huskPlotMach0 {0.0884696016771,0.0867527527234,0.0850359037696,0.0833190548158,0.082407770684,0.082341588298,0.082275405912,0.0822092235261,0.0826994487443,0.08342745499,0.0841554612357,0.0849304898928,0.0865823482203,0.0882342065478,0.0898860648752,0.0914501868563,0.0929723817337,0.0944945766111,0.0960255261536,0.0978726163803,0.099719706607,0.101566796834,0.10440054788,0.107237261872}

#define c_thrustToFFOverSqrtTempMin 2264.1509434
#define c_thrustToFFOverSqrtTempMax 43773.5849057
#define c_thrustToFFOverSqrtTemp {0.005967974452834754,0.006128988102750719,0.006655120181318398,0.007236550942126244,0.007869349366231546,0.008457752383775967,0.00903173860668297,0.009671552653730155,0.0103066926852721,0.010903761038335971,0.011529530972115022,0.012183055750963217,0.0128535580600231,0.013505115179623795,0.01415667229922449,0.014807704922501993,0.015458705639680758,0.016128068555353797,0.016807868054357668,0.01748776014943413,0.018167988323024773,0.01884821649661542,0.01951403284916034,0.020168465613705833,0.020822898378251322,0.02150439888018498,0.022207436938228145,0.022910474996271312,0.023636939446660024,0.024399715376838604,0.02516249130701718,0.02592639340511458,0.026721467988553647,0.027516542571992715,0.028311617155431783,0.029089429769580608,0.02984396284905773,0.03059849592853485,0.03135302900801197,0.03212567888377348,0.03298479843035039,0.03384391797692729,0.0347030375235042,0.035517994891074364,0.036225694101583994,0.036933393312093624,0.037641092522603246,0.038348791733112876,0.03915390364920068,0.04005354126347125,0.04095317887774181,0.04185281649201237,0.042789943663514726,0.04373571472973262,0.0446814857959505,0.04565778636501602,0.046690839541446524,0.04772389271787701,0.04875694589430751,0.04987455261330452,0.05099360689918511,0.052112661185065697,0.05329420400210398,0.05448845233437472,0.05568270066664548,0.05698049582441977,0.058310247335072674,0.059639998845725586}

#define c_sqrtStandardDayTemp 16.97056275 //sqrt(K)

#define c_standardDayDensity 1.229 //kg/m^3

#define c_standardDayPressure 101325.0 //Pa

#define c_maxTakeoffMass 11113.0

#define c_maxCatMoment 4.0e5

//People seem to think the on-speed AOA is too high. I'm inclined to agree
//so I'm reducing this number to 20.0 (from 25.0) degrees to make it easier on the approach.
#define c_aoaStallClean 20.0

#define c_aoaZeroG 0.2

#define c_gradAOA (27.0 / (c_aoaStallClean - c_aoaZeroG))

#define c_constAOA -(c_aoaZeroG * c_gradAOA)

#define c_fuelDumpRate 5.13 //kg/s

#define c_wingSpan 8.3


#endif //DATA_H